
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ParentValue", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonRootName("ParentValue")
@JsonPropertyOrder({
    "parent",
    "value",
    "extensions"
})
public class ParentValue
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ParentValue>
{

    @XmlAttribute(name = "parent", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("parent")
    private String parent;
    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371269L;

    public ParentValue() {
    }

    @ValueConstructor
    public ParentValue(
        @org.jpmml.model.annotations.Property("parent")
        String parent,
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.parent = parent;
        this.value = value;
    }

    @AlternateValueConstructor
    public ParentValue(Field<?> parentField, Object value) {
        this(((parentField!= null)?parentField.getName():null), value);
    }

    public String requireParent() {
        if (this.parent == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PARENTVALUE_PARENT);
        }
        return this.parent;
    }

    public String getParent() {
        return parent;
    }

    public ParentValue setParent(
        @org.jpmml.model.annotations.Property("parent")
        String parent) {
        this.parent = parent;
        return this;
    }

    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PARENTVALUE_VALUE);
        }
        return this.value;
    }

    public Object getValue() {
        return value;
    }

    public ParentValue setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ParentValue addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
