
package org.dmg.pmml.nearest_neighbor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "InstanceFields", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "instanceFields"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("InstanceFields")
@JsonPropertyOrder({
    "extensions",
    "instanceFields"
})
public class InstanceFields
    extends org.dmg.pmml.PMMLObject
    implements Iterable<InstanceField> , HasExtensions<InstanceFields>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "InstanceField", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("InstanceField")
    private List<InstanceField> instanceFields;
    private final static long serialVersionUID = 67371269L;

    public InstanceFields() {
    }

    @ValueConstructor
    public InstanceFields(
        @Property("instanceFields")
        List<InstanceField> instanceFields) {
        this.instanceFields = instanceFields;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public InstanceFields addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<InstanceField> iterator() {
        return requireInstanceFields().iterator();
    }

    public boolean hasInstanceFields() {
        return ((this.instanceFields!= null)&&(!this.instanceFields.isEmpty()));
    }

    public List<InstanceField> requireInstanceFields() {
        if ((this.instanceFields == null)||this.instanceFields.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.INSTANCEFIELDS_INSTANCEFIELDS);
        }
        return this.instanceFields;
    }

    public List<InstanceField> getInstanceFields() {
        if (instanceFields == null) {
            instanceFields = new ArrayList<InstanceField>();
        }
        return this.instanceFields;
    }

    public InstanceFields addInstanceFields(InstanceField... instanceFields) {
        getInstanceFields().addAll(Arrays.asList(instanceFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasInstanceFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getInstanceFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
