
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "predictiveModelQualities",
    "clusteringModelQualities",
    "correlations"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
@JsonRootName("ModelExplanation")
@JsonPropertyOrder({
    "extensions",
    "predictiveModelQualities",
    "clusteringModelQualities",
    "correlations"
})
public class ModelExplanation
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ModelExplanation>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "PredictiveModelQuality", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("PredictiveModelQuality")
    private List<PredictiveModelQuality> predictiveModelQualities;
    @XmlElement(name = "ClusteringModelQuality", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ClusteringModelQuality")
    private List<ClusteringModelQuality> clusteringModelQualities;
    @XmlElement(name = "Correlations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Correlations")
    private Correlations correlations;
    private final static long serialVersionUID = 67371269L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ModelExplanation addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPredictiveModelQualities() {
        return ((this.predictiveModelQualities!= null)&&(!this.predictiveModelQualities.isEmpty()));
    }

    public List<PredictiveModelQuality> getPredictiveModelQualities() {
        if (predictiveModelQualities == null) {
            predictiveModelQualities = new ArrayList<PredictiveModelQuality>();
        }
        return this.predictiveModelQualities;
    }

    public ModelExplanation addPredictiveModelQualities(PredictiveModelQuality... predictiveModelQualities) {
        getPredictiveModelQualities().addAll(Arrays.asList(predictiveModelQualities));
        return this;
    }

    public boolean hasClusteringModelQualities() {
        return ((this.clusteringModelQualities!= null)&&(!this.clusteringModelQualities.isEmpty()));
    }

    public List<ClusteringModelQuality> getClusteringModelQualities() {
        if (clusteringModelQualities == null) {
            clusteringModelQualities = new ArrayList<ClusteringModelQuality>();
        }
        return this.clusteringModelQualities;
    }

    public ModelExplanation addClusteringModelQualities(ClusteringModelQuality... clusteringModelQualities) {
        getClusteringModelQualities().addAll(Arrays.asList(clusteringModelQualities));
        return this;
    }

    public Correlations getCorrelations() {
        return correlations;
    }

    public ModelExplanation setCorrelations(
        @Property("correlations")
        Correlations correlations) {
        this.correlations = correlations;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPredictiveModelQualities()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPredictiveModelQualities());
            }
            if ((status == VisitorAction.CONTINUE)&&hasClusteringModelQualities()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getClusteringModelQualities());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCorrelations());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
