
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionSize;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NeuralOutputs", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "neuralOutputs"
})
@JsonRootName("NeuralOutputs")
@JsonPropertyOrder({
    "numberOfOutputs",
    "extensions",
    "neuralOutputs"
})
public class NeuralOutputs
    extends org.dmg.pmml.PMMLObject
    implements Iterable<NeuralOutput> , HasExtensions<NeuralOutputs>
{

    @XmlAttribute(name = "numberOfOutputs")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @CollectionSize(("neuralOutputs"))
    @JsonProperty("numberOfOutputs")
    private Integer numberOfOutputs;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "NeuralOutput", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("NeuralOutput")
    private List<NeuralOutput> neuralOutputs;
    private final static long serialVersionUID = 67371269L;

    public NeuralOutputs() {
    }

    @ValueConstructor
    public NeuralOutputs(
        @org.jpmml.model.annotations.Property("neuralOutputs")
        List<NeuralOutput> neuralOutputs) {
        this.neuralOutputs = neuralOutputs;
    }

    public Integer getNumberOfOutputs() {
        return numberOfOutputs;
    }

    public NeuralOutputs setNumberOfOutputs(
        @org.jpmml.model.annotations.Property("numberOfOutputs")
        Integer numberOfOutputs) {
        this.numberOfOutputs = numberOfOutputs;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NeuralOutputs addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<NeuralOutput> iterator() {
        return requireNeuralOutputs().iterator();
    }

    public boolean hasNeuralOutputs() {
        return ((this.neuralOutputs!= null)&&(!this.neuralOutputs.isEmpty()));
    }

    public List<NeuralOutput> requireNeuralOutputs() {
        if ((this.neuralOutputs == null)||this.neuralOutputs.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.NEURALOUTPUTS_NEURALOUTPUTS);
        }
        return this.neuralOutputs;
    }

    public List<NeuralOutput> getNeuralOutputs() {
        if (neuralOutputs == null) {
            neuralOutputs = new ArrayList<NeuralOutput>();
        }
        return this.neuralOutputs;
    }

    public NeuralOutputs addNeuralOutputs(NeuralOutput... neuralOutputs) {
        getNeuralOutputs().addAll(Arrays.asList(neuralOutputs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNeuralOutputs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNeuralOutputs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
