
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionSize;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "VectorFields", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "content"
})
@Added((org.dmg.pmml.Version.PMML_3_1))
@JsonRootName("VectorFields")
@JsonPropertyOrder({
    "numberOfFields",
    "extensions",
    "content"
})
public class VectorFields
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<VectorFields>
{

    @XmlAttribute(name = "numberOfFields")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @CollectionSize(("content"))
    @JsonProperty("numberOfFields")
    private Integer numberOfFields;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.FieldRef.class),
        @XmlElement(name = "CategoricalPredictor", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.regression.CategoricalPredictor.class)
    })
    @JsonProperty("content")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "FieldRef", value = org.dmg.pmml.FieldRef.class),
        @JsonSubTypes.Type(name = "CategoricalPredictor", value = org.dmg.pmml.regression.CategoricalPredictor.class)
    })
    private List<org.dmg.pmml.PMMLObject> content;
    private final static long serialVersionUID = 67371269L;

    public VectorFields() {
    }

    @ValueConstructor
    public VectorFields(
        @org.jpmml.model.annotations.Property("content")
        List<org.dmg.pmml.PMMLObject> content) {
        this.content = content;
    }

    public Integer getNumberOfFields() {
        return numberOfFields;
    }

    public VectorFields setNumberOfFields(
        @org.jpmml.model.annotations.Property("numberOfFields")
        Integer numberOfFields) {
        this.numberOfFields = numberOfFields;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public VectorFields addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(!this.content.isEmpty()));
    }

    public List<org.dmg.pmml.PMMLObject> requireContent() {
        if ((this.content == null)||this.content.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.VECTORFIELDS_CONTENT);
        }
        return this.content;
    }

    public List<org.dmg.pmml.PMMLObject> getContent() {
        if (content == null) {
            content = new ArrayList<org.dmg.pmml.PMMLObject>();
        }
        return this.content;
    }

    public VectorFields addContent(org.dmg.pmml.PMMLObject... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
