
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "FieldValue", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "fieldValues",
    "fieldValueCounts"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("FieldValue")
@JsonPropertyOrder({
    "field",
    "value",
    "extensions",
    "fieldValues",
    "fieldValueCounts"
})
public class FieldValue
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<FieldValue> , HasFieldReference<FieldValue> , HasValue<FieldValue>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "FieldValue", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("FieldValue")
    private List<FieldValue> fieldValues;
    @XmlElement(name = "FieldValueCount", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("FieldValueCount")
    private List<FieldValueCount> fieldValueCounts;
    private final static long serialVersionUID = 67371270L;

    public FieldValue() {
    }

    @ValueConstructor
    public FieldValue(
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("value")
        Object value,
        @org.jpmml.model.annotations.Property("fieldValues")
        List<FieldValue> fieldValues,
        @org.jpmml.model.annotations.Property("fieldValueCounts")
        List<FieldValueCount> fieldValueCounts) {
        this.field = field;
        this.value = value;
        this.fieldValues = fieldValues;
        this.fieldValueCounts = fieldValueCounts;
    }

    @AlternateValueConstructor
    public FieldValue(Field<?> field, Object value, List<FieldValue> fieldValues, List<FieldValueCount> fieldValueCounts) {
        this(((field!= null)?field.getName():null), value, fieldValues, fieldValueCounts);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.FIELDVALUE_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public FieldValue setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.FIELDVALUE_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public FieldValue setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public FieldValue addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldValues() {
        return ((this.fieldValues!= null)&&(!this.fieldValues.isEmpty()));
    }

    public List<FieldValue> requireFieldValues() {
        if ((this.fieldValues == null)||this.fieldValues.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.FIELDVALUE_FIELDVALUES);
        }
        return this.fieldValues;
    }

    public List<FieldValue> getFieldValues() {
        if (fieldValues == null) {
            fieldValues = new ArrayList<FieldValue>();
        }
        return this.fieldValues;
    }

    public FieldValue addFieldValues(FieldValue... fieldValues) {
        getFieldValues().addAll(Arrays.asList(fieldValues));
        return this;
    }

    public boolean hasFieldValueCounts() {
        return ((this.fieldValueCounts!= null)&&(!this.fieldValueCounts.isEmpty()));
    }

    public List<FieldValueCount> requireFieldValueCounts() {
        if ((this.fieldValueCounts == null)||this.fieldValueCounts.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.FIELDVALUE_FIELDVALUECOUNTS);
        }
        return this.fieldValueCounts;
    }

    public List<FieldValueCount> getFieldValueCounts() {
        if (fieldValueCounts == null) {
            fieldValueCounts = new ArrayList<FieldValueCount>();
        }
        return this.fieldValueCounts;
    }

    public FieldValue addFieldValueCounts(FieldValueCount... fieldValueCounts) {
        getFieldValueCounts().addAll(Arrays.asList(fieldValueCounts));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getFieldValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldValueCounts()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getFieldValueCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
