
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "PPCell", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("PPCell")
@JsonPropertyOrder({
    "value",
    "field",
    "parameterName",
    "targetCategory",
    "extensions"
})
public class PPCell
    extends ParameterCell
    implements HasExtensions<PPCell> , HasFieldReference<PPCell> , HasValue<PPCell>
{

    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlAttribute(name = "predictorName", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("predictorName")
    private String field;
    @XmlAttribute(name = "parameterName", required = true)
    @JsonProperty("parameterName")
    private String parameterName;
    @XmlAttribute(name = "targetCategory")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("targetCategory")
    private Object targetCategory;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371270L;

    public PPCell() {
    }

    @ValueConstructor
    public PPCell(
        @org.jpmml.model.annotations.Property("value")
        Object value,
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("parameterName")
        String parameterName) {
        this.value = value;
        this.field = field;
        this.parameterName = parameterName;
    }

    @AlternateValueConstructor
    public PPCell(Object value, Field<?> field, String parameterName) {
        this(value, ((field!= null)?field.getName():null), parameterName);
    }

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PPCELL_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public PPCell setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PPCELL_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public PPCell setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    @Override
    public String requireParameterName() {
        if (this.parameterName == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PPCELL_PARAMETERNAME);
        }
        return this.parameterName;
    }

    @Override
    public String getParameterName() {
        return parameterName;
    }

    @Override
    public PPCell setParameterName(
        @org.jpmml.model.annotations.Property("parameterName")
        String parameterName) {
        this.parameterName = parameterName;
        return this;
    }

    @Override
    public Object getTargetCategory() {
        return targetCategory;
    }

    @Override
    public PPCell setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        Object targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PPCell addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
