
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "GARCH", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "armaPart",
    "garchPart"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("GARCH")
@JsonPropertyOrder({
    "extensions",
    "armaPart",
    "garchPart"
})
public class GARCH
    extends TimeSeriesAlgorithm
    implements HasExtensions<GARCH>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ARMAPart", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ARMAPart")
    private ARMAPart armaPart;
    @XmlElement(name = "GARCHPart", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("GARCHPart")
    private GARCHPart garchPart;
    private final static long serialVersionUID = 67371270L;

    public GARCH() {
    }

    @ValueConstructor
    public GARCH(
        @org.jpmml.model.annotations.Property("armaPart")
        ARMAPart armaPart,
        @org.jpmml.model.annotations.Property("garchPart")
        GARCHPart garchPart) {
        this.armaPart = armaPart;
        this.garchPart = garchPart;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public GARCH addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ARMAPart requireARMAPart() {
        if (this.armaPart == null) {
            throw new MissingElementException(this, PMMLElements.GARCH_ARMAPART);
        }
        return this.armaPart;
    }

    public ARMAPart getARMAPart() {
        return armaPart;
    }

    public GARCH setARMAPart(
        @org.jpmml.model.annotations.Property("armaPart")
        ARMAPart armaPart) {
        this.armaPart = armaPart;
        return this;
    }

    public GARCHPart requireGARCHPart() {
        if (this.garchPart == null) {
            throw new MissingElementException(this, PMMLElements.GARCH_GARCHPART);
        }
        return this.garchPart;
    }

    public GARCHPart getGARCHPart() {
        return garchPart;
    }

    public GARCH setGARCHPart(
        @org.jpmml.model.annotations.Property("garchPart")
        GARCHPart garchPart) {
        this.garchPart = garchPart;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getARMAPart(), getGARCHPart());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
