
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "MeasurementMatrix", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "matrix"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("MeasurementMatrix")
@JsonPropertyOrder({
    "extensions",
    "matrix"
})
public class MeasurementMatrix
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<MeasurementMatrix>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Matrix", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Matrix")
    private Matrix matrix;
    private final static long serialVersionUID = 67371270L;

    public MeasurementMatrix() {
    }

    @ValueConstructor
    public MeasurementMatrix(
        @org.jpmml.model.annotations.Property("matrix")
        Matrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MeasurementMatrix addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Matrix requireMatrix() {
        if (this.matrix == null) {
            throw new MissingElementException(this, PMMLElements.MEASUREMENTMATRIX_MATRIX);
        }
        return this.matrix;
    }

    public Matrix getMatrix() {
        return matrix;
    }

    public MeasurementMatrix setMatrix(
        @org.jpmml.model.annotations.Property("matrix")
        Matrix matrix) {
        this.matrix = matrix;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMatrix());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
