
package org.dmg.pmml.association;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasRequiredId;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionSize;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Itemset", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "itemRefs"
})
@JsonRootName("Itemset")
@JsonPropertyOrder({
    "id",
    "support",
    "numberOfItems",
    "extensions",
    "itemRefs"
})
public class Itemset
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Itemset> , HasRequiredId<Itemset>
{

    @XmlAttribute(name = "id", required = true)
    @JsonProperty("id")
    private String id;
    @XmlAttribute(name = "support")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("support")
    private Number support;
    @XmlAttribute(name = "numberOfItems")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @CollectionSize(("itemRefs"))
    @JsonProperty("numberOfItems")
    private Integer numberOfItems;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ItemRef", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ItemRef")
    private List<ItemRef> itemRefs;
    private final static long serialVersionUID = 67371270L;

    public Itemset() {
    }

    @ValueConstructor
    public Itemset(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
    }

    @Override
    public String requireId() {
        if (this.id == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ITEMSET_ID);
        }
        return this.id;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public Itemset setId(
        @org.jpmml.model.annotations.Property("id")
        String id) {
        this.id = id;
        return this;
    }

    public Number getSupport() {
        return support;
    }

    public Itemset setSupport(
        @org.jpmml.model.annotations.Property("support")
        Number support) {
        this.support = support;
        return this;
    }

    public Integer getNumberOfItems() {
        return numberOfItems;
    }

    public Itemset setNumberOfItems(
        @org.jpmml.model.annotations.Property("numberOfItems")
        Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Itemset addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasItemRefs() {
        return ((this.itemRefs!= null)&&(!this.itemRefs.isEmpty()));
    }

    public List<ItemRef> getItemRefs() {
        if (itemRefs == null) {
            itemRefs = new ArrayList<ItemRef>();
        }
        return this.itemRefs;
    }

    public Itemset addItemRefs(ItemRef... itemRefs) {
        getItemRefs().addAll(Arrays.asList(itemRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItemRefs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getItemRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
