
package org.dmg.pmml.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "CenterFields", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "derivedFields"
})
@Removed((org.dmg.pmml.Version.PMML_3_2))
@JsonRootName("CenterFields")
@JsonPropertyOrder({
    "derivedFields"
})
public class CenterFields
    extends org.dmg.pmml.PMMLObject
{

    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("DerivedField")
    private List<DerivedField> derivedFields;
    private final static long serialVersionUID = 67371270L;

    public CenterFields() {
    }

    @ValueConstructor
    public CenterFields(
        @Property("derivedFields")
        List<DerivedField> derivedFields) {
        this.derivedFields = derivedFields;
    }

    public boolean hasDerivedFields() {
        return ((this.derivedFields!= null)&&(!this.derivedFields.isEmpty()));
    }

    public List<DerivedField> requireDerivedFields() {
        if ((this.derivedFields == null)||this.derivedFields.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.CENTERFIELDS_DERIVEDFIELDS);
        }
        return this.derivedFields;
    }

    public List<DerivedField> getDerivedFields() {
        if (derivedFields == null) {
            derivedFields = new ArrayList<DerivedField>();
        }
        return this.derivedFields;
    }

    public CenterFields addDerivedFields(DerivedField... derivedFields) {
        getDerivedFields().addAll(Arrays.asList(derivedFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasDerivedFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDerivedFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
