
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name = "OUTLIER-TREATMENT-METHOD", namespace = "http://www.dmg.org/PMML-4_4")
@XmlEnum
public enum OutlierTreatmentMethod
    implements StringValue<OutlierTreatmentMethod>
{

    @XmlEnumValue("asIs")
    @JsonProperty("asIs")
    AS_IS("asIs"),
    @XmlEnumValue("asMissingValues")
    @JsonProperty("asMissingValues")
    AS_MISSING_VALUES("asMissingValues"),
    @XmlEnumValue("asExtremeValues")
    @JsonProperty("asExtremeValues")
    AS_EXTREME_VALUES("asExtremeValues");
    private final String value;

    OutlierTreatmentMethod(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static OutlierTreatmentMethod fromValue(String v) {
        for (OutlierTreatmentMethod c: OutlierTreatmentMethod.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
