
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "OutputField", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions",
    "expression",
    "values"
})
@JsonRootName("OutputField")
@JsonPropertyOrder({
    "name",
    "displayName",
    "opType",
    "dataType",
    "targetField",
    "reportField",
    "resultFeature",
    "value",
    "ruleFeature",
    "algorithm",
    "rank",
    "rankBasis",
    "rankOrder",
    "isMultiValued",
    "segmentId",
    "finalResult",
    "extensions",
    "decisions",
    "expression",
    "values"
})
public class OutputField
    extends Field<OutputField>
    implements HasDiscreteDomain<OutputField> , HasExpression<OutputField> , HasExtensions<OutputField> , HasTargetFieldReference<OutputField>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "displayName")
    @JsonProperty("displayName")
    private String displayName;
    @XmlAttribute(name = "optype")
    @JsonProperty("optype")
    private OpType opType;
    @XmlAttribute(name = "dataType", required = true)
    @Required((org.dmg.pmml.Version.PMML_4_3))
    @JsonProperty("dataType")
    private DataType dataType;
    @XmlAttribute(name = "targetField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @Optional((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("targetField")
    private String targetField;
    @XmlAttribute(name = "x-reportField")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @JsonProperty("x-reportField")
    private String reportField;
    @XmlAttribute(name = "feature")
    @JsonProperty("feature")
    private ResultFeature resultFeature;
    @XmlAttribute(name = "value")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlAttribute(name = "ruleFeature")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("ruleFeature")
    private OutputField.RuleFeature ruleFeature;
    @XmlAttribute(name = "algorithm")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("algorithm")
    private OutputField.Algorithm algorithm;
    @XmlAttribute(name = "rank")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("rank")
    private Integer rank;
    @XmlAttribute(name = "rankBasis")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("rankBasis")
    private OutputField.RankBasis rankBasis;
    @XmlAttribute(name = "rankOrder")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @JsonProperty("rankOrder")
    private OutputField.RankOrder rankOrder;
    @XmlAttribute(name = "isMultiValued")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("isMultiValued")
    private String isMultiValued;
    @XmlAttribute(name = "segmentId")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("segmentId")
    private String segmentId;
    @XmlAttribute(name = "isFinalResult")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
    @JsonProperty("isFinalResult")
    private Boolean finalResult;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Decisions", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("Decisions")
    private Decisions decisions;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Lag.class)
    })
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("Expression")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Constant", value = org.dmg.pmml.Constant.class),
        @JsonSubTypes.Type(name = "FieldRef", value = org.dmg.pmml.FieldRef.class),
        @JsonSubTypes.Type(name = "NormContinuous", value = org.dmg.pmml.NormContinuous.class),
        @JsonSubTypes.Type(name = "NormDiscrete", value = org.dmg.pmml.NormDiscrete.class),
        @JsonSubTypes.Type(name = "Discretize", value = org.dmg.pmml.Discretize.class),
        @JsonSubTypes.Type(name = "MapValues", value = org.dmg.pmml.MapValues.class),
        @JsonSubTypes.Type(name = "TextIndex", value = org.dmg.pmml.TextIndex.class),
        @JsonSubTypes.Type(name = "Apply", value = org.dmg.pmml.Apply.class),
        @JsonSubTypes.Type(name = "Aggregate", value = org.dmg.pmml.Aggregate.class),
        @JsonSubTypes.Type(name = "Lag", value = org.dmg.pmml.Lag.class)
    })
    private Expression expression;
    @XmlElement(name = "Value", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("Value")
    private List<Value> values;
    private final static Integer DEFAULT_RANK = new IntegerAdapter().unmarshal("1");
    private final static Boolean DEFAULT_FINAL_RESULT = true;
    private final static long serialVersionUID = 67371270L;

    public OutputField() {
    }

    @ValueConstructor
    public OutputField(
        @org.jpmml.model.annotations.Property("name")
        String name,
        @org.jpmml.model.annotations.Property("opType")
        OpType opType,
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.name = name;
        this.opType = opType;
        this.dataType = dataType;
    }

    @Override
    public String requireName() {
        if (this.name == null) {
            throw new MissingAttributeException(this, PMMLAttributes.OUTPUTFIELD_NAME);
        }
        return this.name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public OutputField setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDisplayName() {
        return displayName;
    }

    @Override
    public OutputField setDisplayName(
        @org.jpmml.model.annotations.Property("displayName")
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public OpType requireOpType() {
        if (this.opType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.OUTPUTFIELD_OPTYPE);
        }
        return this.opType;
    }

    @Override
    public OpType getOpType() {
        return opType;
    }

    @Override
    public OutputField setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public DataType requireDataType() {
        if (this.dataType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.OUTPUTFIELD_DATATYPE);
        }
        return this.dataType;
    }

    @Override
    public DataType getDataType() {
        return dataType;
    }

    @Override
    public OutputField setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public String getTargetField() {
        return targetField;
    }

    @Override
    public OutputField setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        String targetField) {
        this.targetField = targetField;
        return this;
    }

    public String getReportField() {
        return reportField;
    }

    public OutputField setReportField(
        @org.jpmml.model.annotations.Property("reportField")
        String reportField) {
        this.reportField = reportField;
        return this;
    }

    public ResultFeature getResultFeature() {
        if (resultFeature == null) {
            return ResultFeature.PREDICTED_VALUE;
        } else {
            return resultFeature;
        }
    }

    public OutputField setResultFeature(
        @org.jpmml.model.annotations.Property("resultFeature")
        ResultFeature resultFeature) {
        this.resultFeature = resultFeature;
        return this;
    }

    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.OUTPUTFIELD_VALUE);
        }
        return this.value;
    }

    public Object getValue() {
        return value;
    }

    public OutputField setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    public OutputField.RuleFeature getRuleFeature() {
        if (ruleFeature == null) {
            return OutputField.RuleFeature.CONSEQUENT;
        } else {
            return ruleFeature;
        }
    }

    public OutputField setRuleFeature(
        @org.jpmml.model.annotations.Property("ruleFeature")
        OutputField.RuleFeature ruleFeature) {
        this.ruleFeature = ruleFeature;
        return this;
    }

    public OutputField.Algorithm getAlgorithm() {
        if (algorithm == null) {
            return OutputField.Algorithm.EXCLUSIVE_RECOMMENDATION;
        } else {
            return algorithm;
        }
    }

    public OutputField setAlgorithm(
        @org.jpmml.model.annotations.Property("algorithm")
        OutputField.Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public Integer getRank() {
        if (rank == null) {
            return DEFAULT_RANK;
        } else {
            return rank;
        }
    }

    public OutputField setRank(
        @org.jpmml.model.annotations.Property("rank")
        Integer rank) {
        this.rank = rank;
        return this;
    }

    public OutputField.RankBasis getRankBasis() {
        if (rankBasis == null) {
            return OutputField.RankBasis.CONFIDENCE;
        } else {
            return rankBasis;
        }
    }

    public OutputField setRankBasis(
        @org.jpmml.model.annotations.Property("rankBasis")
        OutputField.RankBasis rankBasis) {
        this.rankBasis = rankBasis;
        return this;
    }

    public OutputField.RankOrder getRankOrder() {
        if (rankOrder == null) {
            return OutputField.RankOrder.DESCENDING;
        } else {
            return rankOrder;
        }
    }

    public OutputField setRankOrder(
        @org.jpmml.model.annotations.Property("rankOrder")
        OutputField.RankOrder rankOrder) {
        this.rankOrder = rankOrder;
        return this;
    }

    public String getIsMultiValued() {
        if (isMultiValued == null) {
            return "0";
        } else {
            return isMultiValued;
        }
    }

    public OutputField setIsMultiValued(
        @org.jpmml.model.annotations.Property("isMultiValued")
        String isMultiValued) {
        this.isMultiValued = isMultiValued;
        return this;
    }

    public String getSegmentId() {
        return segmentId;
    }

    public OutputField setSegmentId(
        @org.jpmml.model.annotations.Property("segmentId")
        String segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    public boolean isFinalResult() {
        if (finalResult == null) {
            return DEFAULT_FINAL_RESULT;
        } else {
            return finalResult;
        }
    }

    public OutputField setFinalResult(
        @org.jpmml.model.annotations.Property("finalResult")
        Boolean finalResult) {
        this.finalResult = finalResult;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public OutputField addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Decisions getDecisions() {
        return decisions;
    }

    public OutputField setDecisions(
        @org.jpmml.model.annotations.Property("decisions")
        Decisions decisions) {
        this.decisions = decisions;
        return this;
    }

    @Override
    public Expression requireExpression() {
        if (this.expression == null) {
            throw new MissingElementException(this, PMMLElements.OUTPUTFIELD_EXPRESSION);
        }
        return this.expression;
    }

    @Override
    public Expression getExpression() {
        return expression;
    }

    @Override
    public OutputField setExpression(
        @org.jpmml.model.annotations.Property("expression")
        Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public boolean hasValues() {
        return ((this.values!= null)&&(!this.values.isEmpty()));
    }

    @Override
    public List<Value> getValues() {
        if (values == null) {
            values = new ArrayList<Value>();
        }
        return this.values;
    }

    @Override
    public OutputField addValues(Value... values) {
        getValues().addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getDecisions(), getExpression());
            }
            if ((status == VisitorAction.CONTINUE)&&hasValues()) {
                status = PMMLObject.traverse(visitor, getValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Algorithm
        implements StringValue<OutputField.Algorithm>
    {

        @XmlEnumValue("recommendation")
        @JsonProperty("recommendation")
        RECOMMENDATION("recommendation"),
        @XmlEnumValue("exclusiveRecommendation")
        @JsonProperty("exclusiveRecommendation")
        EXCLUSIVE_RECOMMENDATION("exclusiveRecommendation"),
        @XmlEnumValue("ruleAssociation")
        @JsonProperty("ruleAssociation")
        RULE_ASSOCIATION("ruleAssociation");
        private final String value;

        Algorithm(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static OutputField.Algorithm fromValue(String v) {
            for (OutputField.Algorithm c: OutputField.Algorithm.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum RankBasis
        implements StringValue<OutputField.RankBasis>
    {

        @XmlEnumValue("confidence")
        @JsonProperty("confidence")
        CONFIDENCE("confidence"),
        @XmlEnumValue("support")
        @JsonProperty("support")
        SUPPORT("support"),
        @XmlEnumValue("lift")
        @JsonProperty("lift")
        LIFT("lift"),
        @XmlEnumValue("leverage")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        @JsonProperty("leverage")
        LEVERAGE("leverage"),
        @XmlEnumValue("affinity")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        @JsonProperty("affinity")
        AFFINITY("affinity");
        private final String value;

        RankBasis(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static OutputField.RankBasis fromValue(String v) {
            for (OutputField.RankBasis c: OutputField.RankBasis.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum RankOrder
        implements StringValue<OutputField.RankOrder>
    {

        @XmlEnumValue("descending")
        @JsonProperty("descending")
        DESCENDING("descending"),
        @XmlEnumValue("ascending")
        @JsonProperty("ascending")
        ASCENDING("ascending");
        private final String value;

        RankOrder(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static OutputField.RankOrder fromValue(String v) {
            for (OutputField.RankOrder c: OutputField.RankOrder.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum RuleFeature
        implements StringValue<OutputField.RuleFeature>
    {

        @XmlEnumValue("antecedent")
        @JsonProperty("antecedent")
        ANTECEDENT("antecedent"),
        @XmlEnumValue("consequent")
        @JsonProperty("consequent")
        CONSEQUENT("consequent"),
        @XmlEnumValue("rule")
        @JsonProperty("rule")
        RULE("rule"),
        @XmlEnumValue("ruleId")
        @JsonProperty("ruleId")
        RULE_ID("ruleId"),
        @XmlEnumValue("confidence")
        @JsonProperty("confidence")
        CONFIDENCE("confidence"),
        @XmlEnumValue("support")
        @JsonProperty("support")
        SUPPORT("support"),
        @XmlEnumValue("lift")
        @JsonProperty("lift")
        LIFT("lift"),
        @XmlEnumValue("leverage")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        @JsonProperty("leverage")
        LEVERAGE("leverage"),
        @XmlEnumValue("affinity")
        @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
        @JsonProperty("affinity")
        AFFINITY("affinity");
        private final String value;

        RuleFeature(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static OutputField.RuleFeature fromValue(String v) {
            for (OutputField.RuleFeature c: OutputField.RuleFeature.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
