
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SetReference", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("SetReference")
@JsonPropertyOrder({
    "setId",
    "extensions"
})
public class SetReference
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<SetReference>
{

    @XmlAttribute(name = "setId", required = true)
    @JsonProperty("setId")
    private String setId;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371270L;

    public SetReference() {
    }

    @ValueConstructor
    public SetReference(
        @org.jpmml.model.annotations.Property("setId")
        String setId) {
        this.setId = setId;
    }

    public String requireSetId() {
        if (this.setId == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SETREFERENCE_SETID);
        }
        return this.setId;
    }

    public String getSetId() {
        return setId;
    }

    public SetReference setSetId(
        @org.jpmml.model.annotations.Property("setId")
        String setId) {
        this.setId = setId;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SetReference addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
