
package org.dmg.pmml.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Partition;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CopyConstructor;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "partition",
    "scoreDistributions",
    "nodes",
    "embeddedModel"
})
@JsonRootName("Node")
@JsonPropertyOrder({
    "id",
    "score",
    "recordCount",
    "defaultChild",
    "extensions",
    "predicate",
    "partition",
    "scoreDistributions",
    "nodes",
    "embeddedModel"
})
public class ComplexNode
    extends org.dmg.pmml.tree.Node
    implements HasExtensions<ComplexNode>
{

    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("id")
    private Object id;
    @XmlAttribute(name = "score")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @Optional((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("score")
    private Object score;
    @XmlAttribute(name = "recordCount")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("recordCount")
    private Number recordCount;
    @XmlAttribute(name = "defaultChild")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("defaultChild")
    private Object defaultChild;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.False.class)
    })
    @JsonProperty("Predicate")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimplePredicate", value = org.dmg.pmml.SimplePredicate.class),
        @JsonSubTypes.Type(name = "CompoundPredicate", value = org.dmg.pmml.CompoundPredicate.class),
        @JsonSubTypes.Type(name = "SimpleSetPredicate", value = org.dmg.pmml.SimpleSetPredicate.class),
        @JsonSubTypes.Type(name = "True", value = org.dmg.pmml.True.class),
        @JsonSubTypes.Type(name = "False", value = org.dmg.pmml.False.class)
    })
    private Predicate predicate;
    @XmlElement(name = "Partition", namespace = "http://www.dmg.org/PMML-4_4")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("Partition")
    private Partition partition;
    @XmlElements({
        @XmlElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.ComplexScoreDistribution.class)
    })
    @JsonProperty("ScoreDistribution")
    @JsonTypeInfo(use = JsonTypeInfo.Id.NONE, defaultImpl = org.dmg.pmml.ComplexScoreDistribution.class)
    @JsonDeserialize(contentAs = org.dmg.pmml.ComplexScoreDistribution.class)
    private List<ScoreDistribution> scoreDistributions;
    @XmlElements({
        @XmlElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_4", type = ComplexNode.class)
    })
    @JsonProperty("Node")
    @JsonTypeInfo(use = JsonTypeInfo.Id.NONE, defaultImpl = org.dmg.pmml.tree.ComplexNode.class)
    @JsonDeserialize(contentAs = org.dmg.pmml.tree.ComplexNode.class)
    private List<org.dmg.pmml.tree.Node> nodes;
    @XmlElements({
        @XmlElement(name = "Regression", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.regression.Regression.class),
        @XmlElement(name = "DecisionTree", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.tree.DecisionTree.class)
    })
    @JsonProperty("EmbeddedModel")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Regression", value = org.dmg.pmml.regression.Regression.class),
        @JsonSubTypes.Type(name = "DecisionTree", value = org.dmg.pmml.tree.DecisionTree.class)
    })
    private EmbeddedModel embeddedModel;
    private final static long serialVersionUID = 67371270L;

    public ComplexNode() {
    }

    @CopyConstructor
    public ComplexNode(org.dmg.pmml.tree.Node node) {
        setId(node.getId());
        setScore(node.getScore());
        setRecordCount(node.getRecordCount());
        setDefaultChild(node.getDefaultChild());
        if (node.hasExtensions()) {
            getExtensions().addAll(node.getExtensions());
        }
        setPredicate(node.getPredicate());
        setPartition(node.getPartition());
        if (node.hasScoreDistributions()) {
            getScoreDistributions().addAll(node.getScoreDistributions());
        }
        if (node.hasNodes()) {
            getNodes().addAll(node.getNodes());
        }
        setEmbeddedModel(node.getEmbeddedModel());
    }

    @ValueConstructor
    public ComplexNode(
        @org.jpmml.model.annotations.Property("score")
        Object score,
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate) {
        this.score = score;
        this.predicate = predicate;
    }

    @Override
    public Object getId() {
        return id;
    }

    @Override
    public ComplexNode setId(
        @org.jpmml.model.annotations.Property("id")
        Object id) {
        this.id = id;
        return this;
    }

    @Override
    public Object requireScore() {
        if (this.score == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXNODE_SCORE);
        }
        return this.score;
    }

    @Override
    public Object getScore() {
        return score;
    }

    @Override
    public ComplexNode setScore(
        @org.jpmml.model.annotations.Property("score")
        Object score) {
        this.score = score;
        return this;
    }

    @Override
    public Number getRecordCount() {
        return recordCount;
    }

    @Override
    public ComplexNode setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Number recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    @Override
    public Object requireDefaultChild() {
        if (this.defaultChild == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXNODE_DEFAULTCHILD);
        }
        return this.defaultChild;
    }

    public Object getDefaultChild() {
        return defaultChild;
    }

    public ComplexNode setDefaultChild(
        @org.jpmml.model.annotations.Property("defaultChild")
        Object defaultChild) {
        this.defaultChild = defaultChild;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ComplexNode addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Predicate requirePredicate() {
        if (this.predicate == null) {
            throw new MissingElementException(this, PMMLElements.COMPLEXNODE_PREDICATE);
        }
        return this.predicate;
    }

    @Override
    public Predicate getPredicate() {
        return predicate;
    }

    @Override
    public ComplexNode setPredicate(
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public Partition getPartition() {
        return partition;
    }

    public ComplexNode setPartition(
        @org.jpmml.model.annotations.Property("partition")
        Partition partition) {
        this.partition = partition;
        return this;
    }

    @Override
    public boolean hasScoreDistributions() {
        return ((this.scoreDistributions!= null)&&(!this.scoreDistributions.isEmpty()));
    }

    @Override
    public List<ScoreDistribution> getScoreDistributions() {
        if (scoreDistributions == null) {
            scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    @Override
    public ComplexNode addScoreDistributions(ScoreDistribution... scoreDistributions) {
        getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    public boolean hasNodes() {
        return ((this.nodes!= null)&&(!this.nodes.isEmpty()));
    }

    public List<org.dmg.pmml.tree.Node> getNodes() {
        if (nodes == null) {
            nodes = new ArrayList<org.dmg.pmml.tree.Node>();
        }
        return this.nodes;
    }

    public ComplexNode addNodes(org.dmg.pmml.tree.Node... nodes) {
        getNodes().addAll(Arrays.asList(nodes));
        return this;
    }

    public EmbeddedModel getEmbeddedModel() {
        return embeddedModel;
    }

    public ComplexNode setEmbeddedModel(
        @org.jpmml.model.annotations.Property("embeddedModel")
        EmbeddedModel embeddedModel) {
        this.embeddedModel = embeddedModel;
        return this;
    }

    @Override
    public ComplexNode toComplexNode() {
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getPredicate(), getPartition());
            }
            if ((status == VisitorAction.CONTINUE)&&hasScoreDistributions()) {
                status = PMMLObject.traverse(visitor, getScoreDistributions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasNodes()) {
                status = PMMLObject.traverse(visitor, getNodes());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getEmbeddedModel());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
