
package org.dmg.pmml.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultField;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.dmg.pmml.tree.TreeModel.MissingValueStrategy;
import org.dmg.pmml.tree.TreeModel.NoTrueChildStrategy;
import org.dmg.pmml.tree.TreeModel.SplitCharacteristic;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Deprecated;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "DecisionTree", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "node"
})
@JsonRootName("DecisionTree")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "missingValueStrategy",
    "missingValuePenalty",
    "noTrueChildStrategy",
    "splitCharacteristic",
    "extensions",
    "output",
    "modelStats",
    "targets",
    "localTransformations",
    "resultFields",
    "node"
})
@Deprecated((org.dmg.pmml.Version.PMML_4_1))
public class DecisionTree
    extends EmbeddedModel
    implements HasExtensions<DecisionTree> , HasNode<DecisionTree>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "missingValueStrategy")
    @JsonProperty("missingValueStrategy")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private MissingValueStrategy missingValueStrategy;
    @XmlAttribute(name = "missingValuePenalty")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("missingValuePenalty")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Number missingValuePenalty;
    @XmlAttribute(name = "noTrueChildStrategy")
    @JsonProperty("noTrueChildStrategy")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private NoTrueChildStrategy noTrueChildStrategy;
    @XmlAttribute(name = "splitCharacteristic")
    @JsonProperty("splitCharacteristic")
    private SplitCharacteristic splitCharacteristic;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private ModelStats modelStats;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "ResultField", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ResultField")
    private List<ResultField> resultFields;
    @XmlElements({
        @XmlElement(name = "Node", namespace = "http://www.dmg.org/PMML-4_4", required = true, type = org.dmg.pmml.tree.ComplexNode.class)
    })
    @JsonProperty("Node")
    @JsonTypeInfo(use = JsonTypeInfo.Id.NONE, defaultImpl = org.dmg.pmml.tree.ComplexNode.class)
    @JsonDeserialize(as = org.dmg.pmml.tree.ComplexNode.class)
    private Node node;
    private final static Number DEFAULT_MISSING_VALUE_PENALTY = new ProbabilityNumberAdapter().unmarshal("1.0");
    private final static long serialVersionUID = 67371270L;

    public DecisionTree() {
    }

    @ValueConstructor
    public DecisionTree(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("node")
        Node node) {
        this.miningFunction = miningFunction;
        this.node = node;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public DecisionTree setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DECISIONTREE_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public DecisionTree setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public DecisionTree setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @Override
    public MissingValueStrategy getMissingValueStrategy() {
        if (missingValueStrategy == null) {
            return MissingValueStrategy.NONE;
        } else {
            return missingValueStrategy;
        }
    }

    @Override
    public DecisionTree setMissingValueStrategy(
        @org.jpmml.model.annotations.Property("missingValueStrategy")
        MissingValueStrategy missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
        return this;
    }

    @Override
    public Number getMissingValuePenalty() {
        if (missingValuePenalty == null) {
            return DEFAULT_MISSING_VALUE_PENALTY;
        } else {
            return missingValuePenalty;
        }
    }

    @Override
    public DecisionTree setMissingValuePenalty(
        @org.jpmml.model.annotations.Property("missingValuePenalty")
        Number missingValuePenalty) {
        this.missingValuePenalty = missingValuePenalty;
        return this;
    }

    @Override
    public NoTrueChildStrategy getNoTrueChildStrategy() {
        if (noTrueChildStrategy == null) {
            return NoTrueChildStrategy.RETURN_NULL_PREDICTION;
        } else {
            return noTrueChildStrategy;
        }
    }

    @Override
    public DecisionTree setNoTrueChildStrategy(
        @org.jpmml.model.annotations.Property("noTrueChildStrategy")
        NoTrueChildStrategy noTrueChildStrategy) {
        this.noTrueChildStrategy = noTrueChildStrategy;
        return this;
    }

    @Override
    public SplitCharacteristic getSplitCharacteristic() {
        if (splitCharacteristic == null) {
            return SplitCharacteristic.MULTI_SPLIT;
        } else {
            return splitCharacteristic;
        }
    }

    @Override
    public DecisionTree setSplitCharacteristic(
        @org.jpmml.model.annotations.Property("splitCharacteristic")
        SplitCharacteristic splitCharacteristic) {
        this.splitCharacteristic = splitCharacteristic;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DecisionTree addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Output getOutput() {
        return output;
    }

    @Override
    public DecisionTree setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public DecisionTree setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public Targets getTargets() {
        return targets;
    }

    @Override
    public DecisionTree setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public DecisionTree setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasResultFields() {
        return ((this.resultFields!= null)&&(!this.resultFields.isEmpty()));
    }

    public List<ResultField> getResultFields() {
        if (resultFields == null) {
            resultFields = new ArrayList<ResultField>();
        }
        return this.resultFields;
    }

    public DecisionTree addResultFields(ResultField... resultFields) {
        getResultFields().addAll(Arrays.asList(resultFields));
        return this;
    }

    public Node requireNode() {
        if (this.node == null) {
            throw new MissingElementException(this, PMMLElements.DECISIONTREE_NODE);
        }
        return this.node;
    }

    @Override
    public Node getNode() {
        return node;
    }

    @Override
    public DecisionTree setNode(
        @org.jpmml.model.annotations.Property("node")
        Node node) {
        this.node = node;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getOutput(), getModelStats(), getTargets(), getLocalTransformations());
            }
            if ((status == VisitorAction.CONTINUE)&&hasResultFields()) {
                status = PMMLObject.traverse(visitor, getResultFields());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getNode());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
