
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "UniformDistribution", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("UniformDistribution")
@JsonPropertyOrder({
    "lower",
    "upper",
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class UniformDistribution
    extends ContinuousDistribution
    implements HasExtensions<UniformDistribution>
{

    @XmlAttribute(name = "lower", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("lower")
    private Number lower;
    @XmlAttribute(name = "upper", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("upper")
    private Number upper;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371270L;

    public UniformDistribution() {
    }

    @ValueConstructor
    public UniformDistribution(
        @org.jpmml.model.annotations.Property("lower")
        Number lower,
        @org.jpmml.model.annotations.Property("upper")
        Number upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public Number requireLower() {
        if (this.lower == null) {
            throw new MissingAttributeException(this, PMMLAttributes.UNIFORMDISTRIBUTION_LOWER);
        }
        return this.lower;
    }

    public Number getLower() {
        return lower;
    }

    public UniformDistribution setLower(
        @org.jpmml.model.annotations.Property("lower")
        Number lower) {
        this.lower = lower;
        return this;
    }

    public Number requireUpper() {
        if (this.upper == null) {
            throw new MissingAttributeException(this, PMMLAttributes.UNIFORMDISTRIBUTION_UPPER);
        }
        return this.upper;
    }

    public Number getUpper() {
        return upper;
    }

    public UniformDistribution setUpper(
        @org.jpmml.model.annotations.Property("upper")
        Number upper) {
        this.upper = upper;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public UniformDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
