
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name = "INVALID-VALUE-TREATMENT-METHOD", namespace = "http://www.dmg.org/PMML-4_4")
@XmlEnum
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
public enum InvalidValueTreatmentMethod
    implements StringValue<InvalidValueTreatmentMethod>
{

    @XmlEnumValue("returnInvalid")
    @JsonProperty("returnInvalid")
    RETURN_INVALID("returnInvalid"),
    @XmlEnumValue("asIs")
    @JsonProperty("asIs")
    AS_IS("asIs"),
    @XmlEnumValue("asMissing")
    @JsonProperty("asMissing")
    AS_MISSING("asMissing"),
    @XmlEnumValue("asValue")
    @JsonProperty("asValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    AS_VALUE("asValue");
    private final String value;

    InvalidValueTreatmentMethod(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static InvalidValueTreatmentMethod fromValue(String v) {
        for (InvalidValueTreatmentMethod c: InvalidValueTreatmentMethod.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
