
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Since;

@XmlType(name = "MISSING-VALUE-TREATMENT-METHOD", namespace = "http://www.dmg.org/PMML-4_4")
@XmlEnum
public enum MissingValueTreatmentMethod
    implements StringValue<MissingValueTreatmentMethod>
{

    @XmlEnumValue("asIs")
    @JsonProperty("asIs")
    AS_IS("asIs"),
    @XmlEnumValue("asMean")
    @JsonProperty("asMean")
    AS_MEAN("asMean"),
    @XmlEnumValue("asMode")
    @JsonProperty("asMode")
    AS_MODE("asMode"),
    @XmlEnumValue("asMedian")
    @JsonProperty("asMedian")
    AS_MEDIAN("asMedian"),
    @XmlEnumValue("asValue")
    @JsonProperty("asValue")
    AS_VALUE("asValue"),
    @XmlEnumValue("returnInvalid")
    @JsonProperty("returnInvalid")
    @Added((org.dmg.pmml.Version.PMML_4_4))
    @Since(("1.4.2"))
    RETURN_INVALID("returnInvalid");
    private final String value;

    MissingValueTreatmentMethod(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static MissingValueTreatmentMethod fromValue(String v) {
        for (MissingValueTreatmentMethod c: MissingValueTreatmentMethod.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
