
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NumericPredictor", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("NumericPredictor")
@JsonPropertyOrder({
    "field",
    "exponent",
    "coefficient",
    "extensions"
})
public class NumericPredictor
    extends Term
    implements HasExtensions<NumericPredictor> , HasFieldReference<NumericPredictor>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("name")
    private String field;
    @XmlAttribute(name = "exponent")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("exponent")
    private Integer exponent;
    @XmlAttribute(name = "coefficient", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("coefficient")
    private Number coefficient;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Integer DEFAULT_EXPONENT = new IntegerAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371270L;

    public NumericPredictor() {
    }

    @ValueConstructor
    public NumericPredictor(
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("coefficient")
        Number coefficient) {
        this.field = field;
        this.coefficient = coefficient;
    }

    @AlternateValueConstructor
    public NumericPredictor(Field<?> field, Number coefficient) {
        this(((field!= null)?field.requireName():null), coefficient);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NUMERICPREDICTOR_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public NumericPredictor setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public Integer getExponent() {
        if (exponent == null) {
            return DEFAULT_EXPONENT;
        } else {
            return exponent;
        }
    }

    public NumericPredictor setExponent(
        @org.jpmml.model.annotations.Property("exponent")
        Integer exponent) {
        this.exponent = exponent;
        return this;
    }

    @Override
    public Number requireCoefficient() {
        if (this.coefficient == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NUMERICPREDICTOR_COEFFICIENT);
        }
        return this.coefficient;
    }

    @Override
    public Number getCoefficient() {
        return coefficient;
    }

    @Override
    public NumericPredictor setCoefficient(
        @org.jpmml.model.annotations.Property("coefficient")
        Number coefficient) {
        this.coefficient = coefficient;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NumericPredictor addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
