
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SupportVectorMachineModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "kernel",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
@JsonRootName("SupportVectorMachineModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "threshold",
    "representation",
    "alternateBinaryTargetCategory",
    "classificationMethod",
    "maxWins",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "kernel",
    "vectorDictionary",
    "supportVectorMachines",
    "modelVerification"
})
public class SupportVectorMachineModel
    extends Model
    implements HasExtensions<SupportVectorMachineModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "threshold")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("threshold")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private Number threshold;
    @XmlAttribute(name = "svmRepresentation")
    @JsonProperty("svmRepresentation")
    private SupportVectorMachineModel.Representation representation;
    @XmlAttribute(name = "alternateBinaryTargetCategory")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("alternateBinaryTargetCategory")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @Removed((org.dmg.pmml.Version.PMML_4_0))
    private Object alternateBinaryTargetCategory;
    @XmlAttribute(name = "classificationMethod")
    @JsonProperty("classificationMethod")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    private SupportVectorMachineModel.ClassificationMethod classificationMethod;
    @XmlAttribute(name = "maxWins")
    @JsonProperty("maxWins")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
    private Boolean maxWins;
    @XmlAttribute(name = "isScorable")
    @JsonProperty("isScorable")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @JsonProperty("x-mathContext")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.XPMML), removable = (true))
    @Since(("1.3.7"))
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelExplanation")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_0), removable = (true))
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElements({
        @XmlElement(name = "LinearKernelType", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.support_vector_machine.LinearKernel.class),
        @XmlElement(name = "PolynomialKernelType", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.support_vector_machine.PolynomialKernel.class),
        @XmlElement(name = "RadialBasisKernelType", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.support_vector_machine.RadialBasisKernel.class),
        @XmlElement(name = "SigmoidKernelType", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.support_vector_machine.SigmoidKernel.class)
    })
    @JsonProperty("Kernel")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "LinearKernel", value = org.dmg.pmml.support_vector_machine.LinearKernel.class),
        @JsonSubTypes.Type(name = "PolynomialKernel", value = org.dmg.pmml.support_vector_machine.PolynomialKernel.class),
        @JsonSubTypes.Type(name = "RadialBasisKernel", value = org.dmg.pmml.support_vector_machine.RadialBasisKernel.class),
        @JsonSubTypes.Type(name = "SigmoidKernel", value = org.dmg.pmml.support_vector_machine.SigmoidKernel.class)
    })
    private Kernel kernel;
    @XmlElement(name = "VectorDictionary", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("VectorDictionary")
    @Required((org.dmg.pmml.Version.PMML_3_1))
    private VectorDictionary vectorDictionary;
    @XmlElement(name = "SupportVectorMachine", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("SupportVectorMachine")
    private List<SupportVectorMachine> supportVectorMachines;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Number DEFAULT_THRESHOLD = new RealNumberAdapter().unmarshal("0");
    private final static Boolean DEFAULT_MAX_WINS = false;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371270L;

    public SupportVectorMachineModel() {
    }

    @ValueConstructor
    public SupportVectorMachineModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("kernel")
        Kernel kernel,
        @org.jpmml.model.annotations.Property("vectorDictionary")
        VectorDictionary vectorDictionary,
        @org.jpmml.model.annotations.Property("supportVectorMachines")
        List<SupportVectorMachine> supportVectorMachines) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.kernel = kernel;
        this.vectorDictionary = vectorDictionary;
        this.supportVectorMachines = supportVectorMachines;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public SupportVectorMachineModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SUPPORTVECTORMACHINEMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public SupportVectorMachineModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public SupportVectorMachineModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Number getThreshold() {
        if (threshold == null) {
            return DEFAULT_THRESHOLD;
        } else {
            return threshold;
        }
    }

    public SupportVectorMachineModel setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Number threshold) {
        this.threshold = threshold;
        return this;
    }

    public SupportVectorMachineModel.Representation getRepresentation() {
        if (representation == null) {
            return SupportVectorMachineModel.Representation.SUPPORT_VECTORS;
        } else {
            return representation;
        }
    }

    public SupportVectorMachineModel setRepresentation(
        @org.jpmml.model.annotations.Property("representation")
        SupportVectorMachineModel.Representation representation) {
        this.representation = representation;
        return this;
    }

    public Object getAlternateBinaryTargetCategory() {
        return alternateBinaryTargetCategory;
    }

    public SupportVectorMachineModel setAlternateBinaryTargetCategory(
        @org.jpmml.model.annotations.Property("alternateBinaryTargetCategory")
        Object alternateBinaryTargetCategory) {
        this.alternateBinaryTargetCategory = alternateBinaryTargetCategory;
        return this;
    }

    public SupportVectorMachineModel.ClassificationMethod getClassificationMethod() {
        if (classificationMethod == null) {
            return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ALL;
        } else {
            return classificationMethod;
        }
    }

    public SupportVectorMachineModel setClassificationMethod(
        @org.jpmml.model.annotations.Property("classificationMethod")
        SupportVectorMachineModel.ClassificationMethod classificationMethod) {
        this.classificationMethod = classificationMethod;
        return this;
    }

    public boolean isMaxWins() {
        if (maxWins == null) {
            return DEFAULT_MAX_WINS;
        } else {
            return maxWins;
        }
    }

    public SupportVectorMachineModel setMaxWins(
        @org.jpmml.model.annotations.Property("maxWins")
        Boolean maxWins) {
        this.maxWins = maxWins;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    @Override
    public SupportVectorMachineModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    @Override
    public SupportVectorMachineModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SupportVectorMachineModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORMACHINEMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    @Override
    public SupportVectorMachineModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return output;
    }

    @Override
    public SupportVectorMachineModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public SupportVectorMachineModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    @Override
    public SupportVectorMachineModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return targets;
    }

    @Override
    public SupportVectorMachineModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public SupportVectorMachineModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Kernel requireKernel() {
        if (this.kernel == null) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORMACHINEMODEL_KERNEL);
        }
        return this.kernel;
    }

    public Kernel getKernel() {
        return kernel;
    }

    public SupportVectorMachineModel setKernel(
        @org.jpmml.model.annotations.Property("kernel")
        Kernel kernel) {
        this.kernel = kernel;
        return this;
    }

    public VectorDictionary requireVectorDictionary() {
        if (this.vectorDictionary == null) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORMACHINEMODEL_VECTORDICTIONARY);
        }
        return this.vectorDictionary;
    }

    public VectorDictionary getVectorDictionary() {
        return vectorDictionary;
    }

    public SupportVectorMachineModel setVectorDictionary(
        @org.jpmml.model.annotations.Property("vectorDictionary")
        VectorDictionary vectorDictionary) {
        this.vectorDictionary = vectorDictionary;
        return this;
    }

    public boolean hasSupportVectorMachines() {
        return ((this.supportVectorMachines!= null)&&(!this.supportVectorMachines.isEmpty()));
    }

    public List<SupportVectorMachine> requireSupportVectorMachines() {
        if ((this.supportVectorMachines == null)||this.supportVectorMachines.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORMACHINEMODEL_SUPPORTVECTORMACHINES);
        }
        return this.supportVectorMachines;
    }

    public List<SupportVectorMachine> getSupportVectorMachines() {
        if (supportVectorMachines == null) {
            supportVectorMachines = new ArrayList<SupportVectorMachine>();
        }
        return this.supportVectorMachines;
    }

    public SupportVectorMachineModel addSupportVectorMachines(SupportVectorMachine... supportVectorMachines) {
        getSupportVectorMachines().addAll(Arrays.asList(supportVectorMachines));
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    @Override
    public SupportVectorMachineModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getKernel(), getVectorDictionary());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSupportVectorMachines()) {
                status = PMMLObject.traverse(visitor, getSupportVectorMachines());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum ClassificationMethod
        implements StringValue<SupportVectorMachineModel.ClassificationMethod>
    {

        @XmlEnumValue("OneAgainstAll")
        @JsonProperty("OneAgainstAll")
        ONE_AGAINST_ALL("OneAgainstAll"),
        @XmlEnumValue("OneAgainstOne")
        @JsonProperty("OneAgainstOne")
        ONE_AGAINST_ONE("OneAgainstOne");
        private final String value;

        ClassificationMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static SupportVectorMachineModel.ClassificationMethod fromValue(String v) {
            for (SupportVectorMachineModel.ClassificationMethod c: SupportVectorMachineModel.ClassificationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum Representation
        implements StringValue<SupportVectorMachineModel.Representation>
    {

        @XmlEnumValue("SupportVectors")
        @JsonProperty("SupportVectors")
        SUPPORT_VECTORS("SupportVectors"),
        @XmlEnumValue("Coefficients")
        @JsonProperty("Coefficients")
        COEFFICIENTS("Coefficients");
        private final String value;

        Representation(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static SupportVectorMachineModel.Representation fromValue(String v) {
            for (SupportVectorMachineModel.Representation c: SupportVectorMachineModel.Representation.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
