
package org.dmg.pmml.scorecard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Characteristics", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "characteristics"
})
@JsonRootName("Characteristics")
@JsonPropertyOrder({
    "extensions",
    "characteristics"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class Characteristics
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Characteristic> , HasExtensions<Characteristics>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Characteristic", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Characteristic")
    private List<Characteristic> characteristics;
    private final static long serialVersionUID = 67371271L;

    public Characteristics() {
    }

    @ValueConstructor
    public Characteristics(
        @Property("characteristics")
        List<Characteristic> characteristics) {
        this.characteristics = characteristics;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Characteristics addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<Characteristic> iterator() {
        return requireCharacteristics().iterator();
    }

    public boolean hasCharacteristics() {
        return ((this.characteristics!= null)&&(!this.characteristics.isEmpty()));
    }

    public List<Characteristic> requireCharacteristics() {
        if ((this.characteristics == null)||this.characteristics.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.CHARACTERISTICS_CHARACTERISTICS);
        }
        return this.characteristics;
    }

    public List<Characteristic> getCharacteristics() {
        if (characteristics == null) {
            characteristics = new ArrayList<Characteristic>();
        }
        return this.characteristics;
    }

    public Characteristics addCharacteristics(Characteristic... characteristics) {
        getCharacteristics().addAll(Arrays.asList(characteristics));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCharacteristics()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCharacteristics());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
