/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.lang.reflect.AnnotatedElement;
import org.jpmml.model.AnnotationInspector;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;

public class SchemaInspector
extends AnnotationInspector {
    private Version minimum = Version.PMML_3_0;
    private Version maximum = Version.PMML_4_2;

    @Override
    public void inspect(AnnotatedElement element) {
        Removed removed;
        Added added = element.getAnnotation(Added.class);
        if (added != null) {
            this.updateMinimum(added.value());
        }
        if ((removed = element.getAnnotation(Removed.class)) != null) {
            this.updateMaximum(removed.value());
        }
    }

    public Version getMinimum() {
        return this.minimum;
    }

    private void updateMinimum(Version minimum) {
        if (minimum != null && minimum.compareTo((Enum)this.minimum) > 0) {
            this.minimum = minimum;
        }
    }

    public Version getMaximum() {
        return this.maximum;
    }

    private void updateMaximum(Version maximum) {
        if (maximum != null && maximum.compareTo((Enum)this.maximum) < 0) {
            this.maximum = maximum;
        }
    }
}

