/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.dmg.pmml.ValueUtil;

public class IntegerAdapter
extends XmlAdapter<String, Integer> {
    private static final BigInteger MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAX = BigInteger.valueOf(Integer.MAX_VALUE);

    public Integer unmarshal(String value) {
        BigInteger integer = DatatypeConverter.parseInteger((String)value);
        if (!ValueUtil.checkRange(integer, MIN, MAX)) {
            throw new IllegalArgumentException(value);
        }
        return integer.intValue();
    }

    public String marshal(Integer value) {
        if (value == null) {
            return null;
        }
        return DatatypeConverter.printInt((int)value);
    }
}

