/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.dmg.pmml.DecimalAdapter;
import org.dmg.pmml.IntegerAdapter;
import org.dmg.pmml.ValueUtil;
import org.junit.Assert;
import org.junit.Test;

public class ValueUtilTest {
    @Test
    public void checkDecimalRange() {
        BigDecimal min = DecimalAdapter.MIN_VALUE;
        BigDecimal max = DecimalAdapter.MAX_VALUE;
        Assert.assertTrue((boolean)ValueUtil.checkRange((Comparable)BigDecimal.ZERO, (Comparable)min, (Comparable)max));
        Assert.assertTrue((boolean)ValueUtil.checkRange((Comparable)min, (Comparable)min, (Comparable)max));
        Assert.assertFalse((boolean)ValueUtil.checkRange((Comparable)min.subtract(BigDecimal.ONE), (Comparable)min, (Comparable)max));
        Assert.assertTrue((boolean)ValueUtil.checkRange((Comparable)max, (Comparable)min, (Comparable)max));
        Assert.assertFalse((boolean)ValueUtil.checkRange((Comparable)max.add(BigDecimal.ONE), (Comparable)min, (Comparable)max));
    }

    @Test
    public void checkIntegerRange() {
        BigInteger min = IntegerAdapter.MIN_VALUE;
        BigInteger max = IntegerAdapter.MAX_VALUE;
        Assert.assertTrue((boolean)ValueUtil.checkRange((Comparable)BigInteger.ZERO, (Comparable)min, (Comparable)max));
        Assert.assertTrue((boolean)ValueUtil.checkRange((Comparable)min, (Comparable)min, (Comparable)max));
        Assert.assertFalse((boolean)ValueUtil.checkRange((Comparable)min.subtract(BigInteger.ONE), (Comparable)min, (Comparable)max));
        Assert.assertTrue((boolean)ValueUtil.checkRange((Comparable)max, (Comparable)min, (Comparable)max));
        Assert.assertFalse((boolean)ValueUtil.checkRange((Comparable)max.add(BigInteger.ONE), (Comparable)min, (Comparable)max));
    }
}

