/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dmg.pmml.CustomObjectFactory;
import org.dmg.pmml.CustomPMML;
import org.dmg.pmml.PMML;
import org.jpmml.model.JAXBUtil;
import org.jpmml.model.PMMLUtil;
import org.jpmml.schema.Version;
import org.junit.Assert;
import org.junit.Test;

public class JAXBUtilTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void copy() throws Exception {
        PMML pmml;
        InputStream is = PMMLUtil.getResourceAsStream(Version.PMML_4_2);
        try {
            pmml = JAXBUtil.unmarshalPMML((Source)new StreamSource(is));
        }
        finally {
            is.close();
        }
        Assert.assertEquals(PMML.class, pmml.getClass());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBUtil.marshalPMML((PMML)pmml, (Result)new StreamResult(os));
        Assert.assertTrue((os.size() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void copyCustom() throws Exception {
        PMML pmml;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CustomObjectFactory.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("com.sun.xml.bind.ObjectFactory", (Object)new CustomObjectFactory());
        InputStream is = PMMLUtil.getResourceAsStream(Version.PMML_4_2);
        try {
            pmml = JAXBUtil.unmarshalPMML((Unmarshaller)unmarshaller, (Source)new StreamSource(is));
        }
        finally {
            is.close();
        }
        Assert.assertEquals(CustomPMML.class, pmml.getClass());
        Marshaller marshaller = context.createMarshaller();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBUtil.marshalPMML((Marshaller)marshaller, (PMML)pmml, (Result)new StreamResult(os));
        Assert.assertTrue((os.size() > 0 ? 1 : 0) != 0);
    }
}

