/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.io.NotSerializableException;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Annotation;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Header;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Visitor;
import org.jpmml.model.PMMLUtil;
import org.jpmml.model.SerializationUtil;
import org.jpmml.model.SourceLocationTransformer;
import org.junit.Assert;
import org.junit.Test;

public class MixedContentTest {
    @Test
    public void mixedContent() throws Exception {
        PMML pmml = PMMLUtil.loadResource(this.getClass());
        Header header = pmml.getHeader();
        List annotations = header.getAnnotations();
        Annotation annotation = (Annotation)annotations.get(0);
        List content = annotation.getContent();
        Assert.assertEquals((long)5L, (long)content.size());
        Assert.assertEquals((Object)"First text value", content.get(0));
        Assert.assertEquals(Arrays.asList("First extension"), (Object)((Extension)content.get(1)).getContent());
        Assert.assertEquals((Object)"Second text value", content.get(2));
        Assert.assertEquals(Arrays.asList("Second extension"), (Object)((Extension)content.get(3)).getContent());
        Assert.assertEquals((Object)"Third text value", content.get(4));
        try {
            SerializationUtil.clone(pmml);
            Assert.fail();
        }
        catch (NotSerializableException nse) {
            // empty catch block
        }
        pmml.accept((Visitor)new SourceLocationTransformer());
        SerializationUtil.clone(pmml);
    }
}

