/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dmg.pmml.PMML;
import org.jpmml.model.ExportFilter;
import org.jpmml.model.JAXBUtil;
import org.jpmml.schema.Version;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

public class PMMLUtil {
    private PMMLUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PMML loadResource(Class<?> clazz) throws IOException, JAXBException {
        InputStream is = PMMLUtil.getResourceAsStream(clazz);
        try {
            PMML pMML = JAXBUtil.unmarshalPMML((Source)new StreamSource(is));
            return pMML;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceAsByteArray(Class<?> clazz) throws IOException {
        InputStream is = PMMLUtil.getResourceAsStream(clazz);
        try {
            byte[] byArray = PMMLUtil.toByteArray(is);
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static InputStream getResourceAsStream(Class<?> clazz) {
        String name = clazz.getSimpleName();
        return PMMLUtil.class.getResourceAsStream("/pmml/" + name + ".pmml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PMML loadResource(Version version) throws IOException, JAXBException {
        InputStream is = PMMLUtil.getResourceAsStream(version);
        try {
            PMML pMML = JAXBUtil.unmarshalPMML((Source)new StreamSource(is));
            return pMML;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceAsByteArray(Version version) throws IOException {
        InputStream is = PMMLUtil.getResourceAsStream(version);
        try {
            byte[] byArray = PMMLUtil.toByteArray(is);
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static InputStream getResourceAsStream(Version version) {
        String name = version.getNamespaceURI();
        name = name.substring(name.lastIndexOf(47) + 1);
        return PMMLUtil.class.getResourceAsStream("/pmml/" + name.toLowerCase() + ".pmml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] transform(byte[] bytes, Version version) throws IOException, TransformerConfigurationException, SAXException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler transformer = transformerFactory.newTransformerHandler();
        transformer.setResult(new StreamResult(result));
        ExportFilter exportFilter = new ExportFilter(XMLReaderFactory.createXMLReader(), version);
        exportFilter.setContentHandler((ContentHandler)transformer);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            exportFilter.parse(new InputSource(is));
        }
        finally {
            ((InputStream)is).close();
        }
        return result.toByteArray();
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        int count;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        while ((count = is.read(buffer)) >= 0) {
            result.write(buffer, 0, count);
        }
        return result.toByteArray();
    }
}

