/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.dmg.pmml.PMML;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.jpmml.model.PMMLUtil;
import org.jpmml.schema.Version;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.InputSource;

public class SAXFilterTest {
    @Test
    public void copy() throws Exception {
        Version[] versions;
        for (Version version : versions = Version.values()) {
            byte[] original = PMMLUtil.getResourceAsByteArray(version);
            Assert.assertTrue((boolean)SAXFilterTest.checkVersion(original, version));
            SAXSource source = ImportFilter.apply((InputSource)new InputSource(new ByteArrayInputStream(original)));
            PMML pmml = JAXBUtil.unmarshalPMML((Source)source);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            JAXBUtil.marshalPMML((PMML)pmml, (Result)new StreamResult(buffer));
            byte[] latest = buffer.toByteArray();
            Assert.assertTrue((boolean)SAXFilterTest.checkVersion(latest, Version.PMML_4_2));
            byte[] latestToOriginal = PMMLUtil.transform(latest, version);
            Assert.assertTrue((boolean)SAXFilterTest.checkVersion(latestToOriginal, version));
        }
    }

    private static boolean checkVersion(byte[] bytes, Version version) throws IOException {
        String string = new String(bytes, "UTF-8");
        return string.contains("<PMML xmlns=\"" + version.getNamespaceURI() + "\" version=\"" + version.getVersion() + "\">");
    }
}

