/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.AssociationModel;
import org.dmg.pmml.BaselineModel;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.GeneralRegressionModel;
import org.dmg.pmml.Header;
import org.dmg.pmml.MiningModel;
import org.dmg.pmml.Model;
import org.dmg.pmml.NaiveBayesModel;
import org.dmg.pmml.NearestNeighborModel;
import org.dmg.pmml.NeuralNetwork;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RuleFeatureType;
import org.dmg.pmml.RuleSetModel;
import org.dmg.pmml.Scorecard;
import org.dmg.pmml.SequenceModel;
import org.dmg.pmml.SupportVectorMachineModel;
import org.dmg.pmml.TextModel;
import org.dmg.pmml.TimeSeriesModel;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.TreeModel;
import org.dmg.pmml.Visitor;
import org.jpmml.model.SchemaInspector;
import org.jpmml.schema.Version;
import org.junit.Assert;
import org.junit.Test;

public class SchemaInspectorTest {
    @Test
    public void inspectTypeAnnotations() {
        PMML pmml = new PMML(new Header(), new DataDictionary(), "4.2");
        List models = pmml.getModels();
        Assert.assertEquals((long)0L, (long)models.size());
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_3_0, Version.PMML_4_2);
        pmml.withModels(new Model[]{new AssociationModel(), new ClusteringModel(), new GeneralRegressionModel(), new MiningModel(), new NaiveBayesModel(), new NeuralNetwork(), new RegressionModel(), new RuleSetModel(), new SequenceModel(), new SupportVectorMachineModel(), new TextModel(), new TreeModel()});
        Assert.assertEquals((long)12L, (long)models.size());
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_3_0, Version.PMML_4_2);
        pmml.withModels(new Model[]{new TimeSeriesModel()});
        Assert.assertEquals((long)13L, (long)models.size());
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_4_0, Version.PMML_4_2);
        pmml.withModels(new Model[]{new BaselineModel(), new Scorecard(), new NearestNeighborModel()});
        Assert.assertEquals((long)16L, (long)models.size());
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_4_1, Version.PMML_4_2);
    }

    @Test
    public void inspectFieldAnnotations() {
        PMML pmml = new PMML(new Header(), new DataDictionary(), "4.2");
        AssociationModel model = new AssociationModel();
        pmml.withModels(new Model[]{model});
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_3_0, Version.PMML_4_2);
        Output output = new Output();
        model.withOutput(output);
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_4_0, Version.PMML_4_2);
        model.setScorable(Boolean.FALSE);
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_4_1, Version.PMML_4_2);
        model.setScorable(null);
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_4_0, Version.PMML_4_2);
        OutputField outputField = new OutputField().withRuleFeature(RuleFeatureType.AFFINITY);
        output.withOutputFields(new OutputField[]{outputField});
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_4_1, Version.PMML_4_2);
        model.setOutput(null);
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_3_0, Version.PMML_4_2);
    }

    @Test
    public void inspectFunctions() {
        PMML pmml = new PMML(new Header(), new DataDictionary(), "4.2");
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_3_0, Version.PMML_4_2);
        Apply apply = new Apply();
        apply.setFunction("lowercase");
        DefineFunction defineFunction = new DefineFunction("convert_case", OpType.CATEGORICAL).withParameterFields(new ParameterField[]{new ParameterField(new FieldName("string"))}).withExpression((Expression)apply);
        TransformationDictionary transformationDictionary = new TransformationDictionary().withDefineFunctions(new DefineFunction[]{defineFunction});
        pmml.withTransformationDictionary(transformationDictionary);
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_4_1, Version.PMML_4_2);
        apply.setFunction("uppercase");
        SchemaInspectorTest.assertVersionRange((PMMLObject)pmml, Version.PMML_3_0, Version.PMML_4_2);
    }

    private static void assertVersionRange(PMMLObject object, Version minimum, Version maximum) {
        SchemaInspector inspector = new SchemaInspector();
        object.accept((Visitor)inspector);
        Assert.assertEquals((Object)minimum, (Object)inspector.getMinimum());
        Assert.assertEquals((Object)maximum, (Object)inspector.getMaximum());
    }
}

