/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.dmg.pmml.PMML;
import org.jpmml.model.ImportFilter;
import org.jpmml.model.JAXBUtil;
import org.jpmml.model.PMMLUtil;
import org.jpmml.schema.Version;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.InputSource;

public class TrendExpoSmoothTest {
    @Test
    public void copy() throws Exception {
        byte[] original = PMMLUtil.getResourceAsByteArray(TrendExpoSmoothTest.class);
        Assert.assertTrue((boolean)TrendExpoSmoothTest.checkElement(original, "Trend"));
        SAXSource source = ImportFilter.apply((InputSource)new InputSource(new ByteArrayInputStream(original)));
        PMML pmml = JAXBUtil.unmarshalPMML((Source)source);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        JAXBUtil.marshalPMML((PMML)pmml, (Result)new StreamResult(buffer));
        byte[] latest = buffer.toByteArray();
        Assert.assertTrue((boolean)TrendExpoSmoothTest.checkElement(latest, "Trend_ExpoSmooth"));
        Assert.assertFalse((boolean)TrendExpoSmoothTest.checkElement(latest, "Trend"));
        byte[] latestToOriginal = PMMLUtil.transform(latest, Version.PMML_4_0);
        Assert.assertTrue((boolean)TrendExpoSmoothTest.checkElement(latestToOriginal, "Trend"));
    }

    private static boolean checkElement(byte[] bytes, String tag) throws IOException {
        String string = new String(bytes, "UTF-8");
        return string.contains("<" + tag + "/>");
    }
}

