/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.math.BigDecimal;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.dmg.pmml.ValueUtil;

public class DecimalAdapter
extends XmlAdapter<String, Double> {
    protected static final BigDecimal MIN_VALUE = BigDecimal.valueOf(-1.7976931348623157E308);
    protected static final BigDecimal MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);

    public Double unmarshal(String value) {
        BigDecimal decimal = DatatypeConverter.parseDecimal((String)value);
        if (!ValueUtil.checkRange(decimal, MIN_VALUE, MAX_VALUE)) {
            throw new IllegalArgumentException(value);
        }
        return decimal.doubleValue();
    }

    public String marshal(Double value) {
        if (value == null) {
            return null;
        }
        return DatatypeConverter.printDecimal((BigDecimal)BigDecimal.valueOf(value));
    }
}

