/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.CenterFields;
import org.dmg.pmml.Cluster;
import org.dmg.pmml.ClusteringField;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.MissingValueWeights;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Removed;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "localTransformations", "comparisonMeasure", "clusteringFields", "centerFields", "missingValueWeights", "clusters", "modelVerification"})
@XmlRootElement(name="ClusteringModel", namespace="http://www.dmg.org/PMML-4_2")
public class ClusteringModel
extends Model
implements HasExtensions {
    @XmlAttribute(name="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    private MiningFunctionType functionName;
    @XmlAttribute(name="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="modelClass", required=true)
    private ModelClass modelClass;
    @XmlAttribute(name="numberOfClusters", required=true)
    @XmlJavaTypeAdapter(value=IntegerAdapter.class)
    private Integer numberOfClusters;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    private Boolean scorable;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_2")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_2")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_2")
    @Added(value=Version.PMML_4_0)
    private ModelExplanation modelExplanation;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_2")
    private LocalTransformations localTransformations;
    @XmlElement(name="ComparisonMeasure", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private ComparisonMeasure comparisonMeasure;
    @XmlElement(name="ClusteringField", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private List<ClusteringField> clusteringFields;
    @XmlElement(name="CenterFields", namespace="http://www.dmg.org/PMML-4_2")
    @Removed(value=Version.PMML_3_2)
    private CenterFields centerFields;
    @XmlElement(name="MissingValueWeights", namespace="http://www.dmg.org/PMML-4_2")
    private MissingValueWeights missingValueWeights;
    @XmlElement(name="Cluster", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private List<Cluster> clusters;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_2")
    private ModelVerification modelVerification;

    public ClusteringModel() {
    }

    public ClusteringModel(MiningFunctionType functionName, ModelClass modelClass, Integer numberOfClusters, MiningSchema miningSchema, ComparisonMeasure comparisonMeasure, List<ClusteringField> clusteringFields, List<Cluster> clusters) {
        this.functionName = functionName;
        this.modelClass = modelClass;
        this.numberOfClusters = numberOfClusters;
        this.miningSchema = miningSchema;
        this.comparisonMeasure = comparisonMeasure;
        this.clusteringFields = clusteringFields;
        this.clusters = clusters;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public ClusteringModel setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunctionType getFunctionName() {
        return this.functionName;
    }

    @Override
    public ClusteringModel setFunctionName(MiningFunctionType functionName) {
        this.functionName = functionName;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public ClusteringModel setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public ModelClass getModelClass() {
        return this.modelClass;
    }

    public ClusteringModel setModelClass(ModelClass modelClass) {
        this.modelClass = modelClass;
        return this;
    }

    public Integer getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public ClusteringModel setNumberOfClusters(Integer numberOfClusters) {
        this.numberOfClusters = numberOfClusters;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return true;
        }
        return this.scorable;
    }

    @Override
    public ClusteringModel setScorable(Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public ClusteringModel setMiningSchema(MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public ClusteringModel setOutput(Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public ClusteringModel setModelStats(ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public ClusteringModel setModelExplanation(ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public ClusteringModel setLocalTransformations(LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public ComparisonMeasure getComparisonMeasure() {
        return this.comparisonMeasure;
    }

    public ClusteringModel setComparisonMeasure(ComparisonMeasure comparisonMeasure) {
        this.comparisonMeasure = comparisonMeasure;
        return this;
    }

    public List<ClusteringField> getClusteringFields() {
        if (this.clusteringFields == null) {
            this.clusteringFields = new ArrayList<ClusteringField>();
        }
        return this.clusteringFields;
    }

    public CenterFields getCenterFields() {
        return this.centerFields;
    }

    public ClusteringModel setCenterFields(CenterFields centerFields) {
        this.centerFields = centerFields;
        return this;
    }

    public MissingValueWeights getMissingValueWeights() {
        return this.missingValueWeights;
    }

    public ClusteringModel setMissingValueWeights(MissingValueWeights missingValueWeights) {
        this.missingValueWeights = missingValueWeights;
        return this;
    }

    public List<Cluster> getClusters() {
        if (this.clusters == null) {
            this.clusters = new ArrayList<Cluster>();
        }
        return this.clusters;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public ClusteringModel setModelVerification(ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public ClusteringModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasClusteringFields() {
        return this.clusteringFields != null && this.clusteringFields.size() > 0;
    }

    public ClusteringModel addClusteringFields(ClusteringField ... clusteringFields) {
        this.getClusteringFields().addAll(Arrays.asList(clusteringFields));
        return this;
    }

    public boolean hasClusters() {
        return this.clusters != null && this.clusters.size() > 0;
    }

    public ClusteringModel addClusters(Cluster ... clusters) {
        this.getClusters().addAll(Arrays.asList(clusters));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getLocalTransformations(), this.getComparisonMeasure());
        }
        if (status == VisitorAction.CONTINUE && this.hasClusteringFields()) {
            status = PMMLObject.traverse(visitor, this.getClusteringFields());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getCenterFields(), this.getMissingValueWeights());
        }
        if (status == VisitorAction.CONTINUE && this.hasClusters()) {
            status = PMMLObject.traverse(visitor, this.getClusters());
        }
        if (status == VisitorAction.CONTINUE) {
            status = PMMLObject.traverse(visitor, this.getModelVerification());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ModelClass {
        CENTER_BASED("centerBased"),
        DISTRIBUTION_BASED("distributionBased");

        private final String value;

        private ModelClass(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ModelClass fromValue(String v) {
            for (ModelClass c : ModelClass.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

