/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Quantile;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "quantiles"})
@XmlRootElement(name="NumericInfo", namespace="http://www.dmg.org/PMML-4_2")
public class NumericInfo
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="minimum")
    private Double minimum;
    @XmlAttribute(name="maximum")
    private Double maximum;
    @XmlAttribute(name="mean")
    private Double mean;
    @XmlAttribute(name="standardDeviation")
    private Double standardDeviation;
    @XmlAttribute(name="median")
    private Double median;
    @XmlAttribute(name="interQuartileRange")
    private Double interQuartileRange;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="Quantile", namespace="http://www.dmg.org/PMML-4_2")
    private List<Quantile> quantiles;

    public Double getMinimum() {
        return this.minimum;
    }

    public NumericInfo setMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public NumericInfo setMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public Double getMean() {
        return this.mean;
    }

    public NumericInfo setMean(Double mean) {
        this.mean = mean;
        return this;
    }

    public Double getStandardDeviation() {
        return this.standardDeviation;
    }

    public NumericInfo setStandardDeviation(Double standardDeviation) {
        this.standardDeviation = standardDeviation;
        return this;
    }

    public Double getMedian() {
        return this.median;
    }

    public NumericInfo setMedian(Double median) {
        this.median = median;
        return this;
    }

    public Double getInterQuartileRange() {
        return this.interQuartileRange;
    }

    public NumericInfo setInterQuartileRange(Double interQuartileRange) {
        this.interQuartileRange = interQuartileRange;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Quantile> getQuantiles() {
        if (this.quantiles == null) {
            this.quantiles = new ArrayList<Quantile>();
        }
        return this.quantiles;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public NumericInfo addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasQuantiles() {
        return this.quantiles != null && this.quantiles.size() > 0;
    }

    public NumericInfo addQuantiles(Quantile ... quantiles) {
        this.getQuantiles().addAll(Arrays.asList(quantiles));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE && this.hasQuantiles()) {
            status = PMMLObject.traverse(visitor, this.getQuantiles());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

