/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Connection;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "connections"})
@XmlRootElement(name="Neuron", namespace="http://www.dmg.org/PMML-4_2")
public class Neuron
extends Entity
implements HasExtensions {
    @XmlAttribute(name="id", required=true)
    private String id;
    @XmlAttribute(name="bias")
    private Double bias;
    @XmlAttribute(name="width")
    private Double width;
    @XmlAttribute(name="altitude")
    @Added(value=Version.PMML_3_2)
    private Double altitude;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="Con", namespace="http://www.dmg.org/PMML-4_2", required=true)
    private List<Connection> connections;

    public Neuron() {
    }

    public Neuron(String id, List<Connection> connections) {
        this.id = id;
        this.connections = connections;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Neuron setId(String id) {
        this.id = id;
        return this;
    }

    public Double getBias() {
        return this.bias;
    }

    public Neuron setBias(Double bias) {
        this.bias = bias;
        return this;
    }

    public Double getWidth() {
        return this.width;
    }

    public Neuron setWidth(Double width) {
        this.width = width;
        return this;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public Neuron setAltitude(Double altitude) {
        this.altitude = altitude;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Connection> getConnections() {
        if (this.connections == null) {
            this.connections = new ArrayList<Connection>();
        }
        return this.connections;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public Neuron addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasConnections() {
        return this.connections != null && this.connections.size() > 0;
    }

    public Neuron addConnections(Connection ... connections) {
        this.getConnections().addAll(Arrays.asList(connections));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
            status = PMMLObject.traverse(visitor, this.getExtensions());
        }
        if (status == VisitorAction.CONTINUE && this.hasConnections()) {
            status = PMMLObject.traverse(visitor, this.getConnections());
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

