/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.time_series.TimeCycle;
import org.dmg.pmml.time_series.TimeException;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"timeCycles", "timeExceptions"})
@XmlRootElement(name="TimeAnchor", namespace="http://www.dmg.org/PMML-4_3")
@Added(value=Version.PMML_4_0)
public class TimeAnchor
extends PMMLObject {
    @XmlAttribute(name="type")
    private Type type;
    @XmlAttribute(name="offset")
    private Integer offset;
    @XmlAttribute(name="stepsize")
    private Integer stepsize;
    @XmlAttribute(name="displayName")
    @XmlSchemaType(name="anySimpleType")
    private String displayName;
    @XmlElement(name="TimeCycle", namespace="http://www.dmg.org/PMML-4_3")
    private List<TimeCycle> timeCycles;
    @XmlElement(name="TimeException", namespace="http://www.dmg.org/PMML-4_3")
    private List<TimeException> timeExceptions;

    public Type getType() {
        return this.type;
    }

    public TimeAnchor setType(Type type) {
        this.type = type;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public TimeAnchor setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer getStepsize() {
        return this.stepsize;
    }

    public TimeAnchor setStepsize(Integer stepsize) {
        this.stepsize = stepsize;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TimeAnchor setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public List<TimeCycle> getTimeCycles() {
        if (this.timeCycles == null) {
            this.timeCycles = new ArrayList<TimeCycle>();
        }
        return this.timeCycles;
    }

    public List<TimeException> getTimeExceptions() {
        if (this.timeExceptions == null) {
            this.timeExceptions = new ArrayList<TimeException>();
        }
        return this.timeExceptions;
    }

    public boolean hasTimeCycles() {
        return this.timeCycles != null && this.timeCycles.size() > 0;
    }

    public TimeAnchor addTimeCycles(TimeCycle ... timeCycles) {
        this.getTimeCycles().addAll(Arrays.asList(timeCycles));
        return this;
    }

    public boolean hasTimeExceptions() {
        return this.timeExceptions != null && this.timeExceptions.size() > 0;
    }

    public TimeAnchor addTimeExceptions(TimeException ... timeExceptions) {
        this.getTimeExceptions().addAll(Arrays.asList(timeExceptions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasTimeCycles()) {
                status = PMMLObject.traverse(visitor, this.getTimeCycles());
            }
            if (status == VisitorAction.CONTINUE && this.hasTimeExceptions()) {
                status = PMMLObject.traverse(visitor, this.getTimeExceptions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    @Added(value=Version.PMML_4_0)
    public static enum Type {
        DATE_TIME_MILLISECONDS_SINCE_0("dateTimeMillisecondsSince[0]"),
        DATE_TIME_MILLISECONDS_SINCE_1960("dateTimeMillisecondsSince[1960]"),
        DATE_TIME_MILLISECONDS_SINCE_1970("dateTimeMillisecondsSince[1970]"),
        DATE_TIME_MILLISECONDS_SINCE_1980("dateTimeMillisecondsSince[1980]"),
        DATE_TIME_SECONDS_SINCE_0("dateTimeSecondsSince[0]"),
        DATE_TIME_SECONDS_SINCE_1960("dateTimeSecondsSince[1960]"),
        DATE_TIME_SECONDS_SINCE_1970("dateTimeSecondsSince[1970]"),
        DATE_TIME_SECONDS_SINCE_1980("dateTimeSecondsSince[1980]"),
        DATE_DAYS_SINCE_0("dateDaysSince[0]"),
        DATE_DAYS_SINCE_1960("dateDaysSince[1960]"),
        DATE_DAYS_SINCE_1970("dateDaysSince[1970]"),
        DATE_DAYS_SINCE_1980("dateDaysSince[1980]"),
        DATE_MONTHS_SINCE_0("dateMonthsSince[0]"),
        DATE_MONTHS_SINCE_1960("dateMonthsSince[1960]"),
        DATE_MONTHS_SINCE_1970("dateMonthsSince[1970]"),
        DATE_MONTHS_SINCE_1980("dateMonthsSince[1980]"),
        DATE_YEARS_SINCE_0("dateYearsSince[0]");

        private final String value;

        private Type(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Type fromValue(String v) {
            for (Type c : Type.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

