/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.tree;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.EmbeddedModel;
import org.dmg.pmml.Extension;
import org.dmg.pmml.False;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Partition;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.regression.Regression;
import org.dmg.pmml.tree.DecisionTree;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.PMMLAttributes;
import org.dmg.pmml.tree.PMMLElements;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CopyConstructor;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Node", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "predicate", "partition", "scoreDistributions", "nodes", "embeddedModel"})
@JsonRootName(value="Node")
@JsonPropertyOrder(value={"id", "score", "recordCount", "defaultChild", "extensions", "predicate", "partition", "scoreDistributions", "nodes", "embeddedModel"})
public class ComplexNode
extends Node
implements HasExtensions<ComplexNode> {
    @XmlAttribute(name="id")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @JsonProperty(value="id")
    private Object id;
    @XmlAttribute(name="score")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @Optional(value=Version.PMML_3_2)
    @JsonProperty(value="score")
    private Object score;
    @XmlAttribute(name="recordCount")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="recordCount")
    private Number recordCount;
    @XmlAttribute(name="defaultChild")
    @XmlJavaTypeAdapter(value=ObjectAdapter.class)
    @XmlSchemaType(name="anySimpleType")
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="defaultChild")
    private Object defaultChild;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElements(value={@XmlElement(name="SimplePredicate", namespace="http://www.dmg.org/PMML-4_4", type=SimplePredicate.class), @XmlElement(name="CompoundPredicate", namespace="http://www.dmg.org/PMML-4_4", type=CompoundPredicate.class), @XmlElement(name="SimpleSetPredicate", namespace="http://www.dmg.org/PMML-4_4", type=SimpleSetPredicate.class), @XmlElement(name="True", namespace="http://www.dmg.org/PMML-4_4", type=True.class), @XmlElement(name="False", namespace="http://www.dmg.org/PMML-4_4", type=False.class)})
    @JsonProperty(value="Predicate")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="SimplePredicate", value=SimplePredicate.class), @JsonSubTypes.Type(name="CompoundPredicate", value=CompoundPredicate.class), @JsonSubTypes.Type(name="SimpleSetPredicate", value=SimpleSetPredicate.class), @JsonSubTypes.Type(name="True", value=True.class), @JsonSubTypes.Type(name="False", value=False.class)})
    private Predicate predicate;
    @XmlElement(name="Partition", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_3_2)
    @JsonProperty(value="Partition")
    private Partition partition;
    @XmlElement(name="ScoreDistribution", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ScoreDistribution")
    private List<ScoreDistribution> scoreDistributions;
    @XmlElements(value={@XmlElement(name="Node", namespace="http://www.dmg.org/PMML-4_4", type=ComplexNode.class)})
    @JsonProperty(value="Node")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE, defaultImpl=ComplexNode.class)
    @JsonDeserialize(contentAs=ComplexNode.class)
    private List<Node> nodes;
    @XmlElements(value={@XmlElement(name="Regression", namespace="http://www.dmg.org/PMML-4_4", type=Regression.class), @XmlElement(name="DecisionTree", namespace="http://www.dmg.org/PMML-4_4", type=DecisionTree.class)})
    @JsonProperty(value="EmbeddedModel")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="Regression", value=Regression.class), @JsonSubTypes.Type(name="DecisionTree", value=DecisionTree.class)})
    private EmbeddedModel embeddedModel;
    private static final long serialVersionUID = 67371269L;

    public ComplexNode() {
    }

    @CopyConstructor
    public ComplexNode(Node node) {
        this.setId(node.getId());
        this.setScore(node.getScore());
        this.setRecordCount(node.getRecordCount());
        this.setDefaultChild(node.getDefaultChild());
        if (node.hasExtensions()) {
            this.getExtensions().addAll(node.getExtensions());
        }
        this.setPredicate(node.getPredicate());
        this.setPartition(node.getPartition());
        if (node.hasScoreDistributions()) {
            this.getScoreDistributions().addAll(node.getScoreDistributions());
        }
        if (node.hasNodes()) {
            this.getNodes().addAll(node.getNodes());
        }
        this.setEmbeddedModel(node.getEmbeddedModel());
    }

    @ValueConstructor
    public ComplexNode(@Property(value="score") Object score, @Property(value="predicate") Predicate predicate) {
        this.score = score;
        this.predicate = predicate;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public ComplexNode setId(@Property(value="id") Object id) {
        this.id = id;
        return this;
    }

    @Override
    public Object requireScore() {
        if (this.score == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXNODE_SCORE);
        }
        return this.score;
    }

    @Override
    public Object getScore() {
        return this.score;
    }

    @Override
    public ComplexNode setScore(@Property(value="score") Object score) {
        this.score = score;
        return this;
    }

    @Override
    public Number getRecordCount() {
        return this.recordCount;
    }

    @Override
    public ComplexNode setRecordCount(@Property(value="recordCount") Number recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    @Override
    public Object requireDefaultChild() {
        if (this.defaultChild == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXNODE_DEFAULTCHILD);
        }
        return this.defaultChild;
    }

    @Override
    public Object getDefaultChild() {
        return this.defaultChild;
    }

    @Override
    public ComplexNode setDefaultChild(@Property(value="defaultChild") Object defaultChild) {
        this.defaultChild = defaultChild;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ComplexNode addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Predicate requirePredicate() {
        if (this.predicate == null) {
            throw new MissingElementException(this, PMMLElements.COMPLEXNODE_PREDICATE);
        }
        return this.predicate;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public ComplexNode setPredicate(@Property(value="predicate") Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public Partition getPartition() {
        return this.partition;
    }

    @Override
    public ComplexNode setPartition(@Property(value="partition") Partition partition) {
        this.partition = partition;
        return this;
    }

    @Override
    public boolean hasScoreDistributions() {
        return this.scoreDistributions != null && !this.scoreDistributions.isEmpty();
    }

    @Override
    public List<ScoreDistribution> getScoreDistributions() {
        if (this.scoreDistributions == null) {
            this.scoreDistributions = new ArrayList<ScoreDistribution>();
        }
        return this.scoreDistributions;
    }

    @Override
    public ComplexNode addScoreDistributions(ScoreDistribution ... scoreDistributions) {
        this.getScoreDistributions().addAll(Arrays.asList(scoreDistributions));
        return this;
    }

    @Override
    public boolean hasNodes() {
        return this.nodes != null && !this.nodes.isEmpty();
    }

    @Override
    public List<Node> getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>();
        }
        return this.nodes;
    }

    @Override
    public ComplexNode addNodes(Node ... nodes) {
        this.getNodes().addAll(Arrays.asList(nodes));
        return this;
    }

    @Override
    public EmbeddedModel getEmbeddedModel() {
        return this.embeddedModel;
    }

    @Override
    public ComplexNode setEmbeddedModel(@Property(value="embeddedModel") EmbeddedModel embeddedModel) {
        this.embeddedModel = embeddedModel;
        return this;
    }

    @Override
    public ComplexNode toComplexNode() {
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getPredicate(), (Visitable)this.getPartition());
            }
            if (status == VisitorAction.CONTINUE && this.hasScoreDistributions()) {
                status = PMMLObject.traverse(visitor, this.getScoreDistributions());
            }
            if (status == VisitorAction.CONTINUE && this.hasNodes()) {
                status = PMMLObject.traverse(visitor, this.getNodes());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getEmbeddedModel());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

