/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.BlockIndicator;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.PositiveIntegerAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Lag", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "blockIndicators"})
@JsonRootName(value="Lag")
@JsonPropertyOrder(value={"field", "n", "aggregate", "extensions", "blockIndicators"})
@Added(value=Version.PMML_4_3)
public class Lag
extends Expression
implements HasExtensions<Lag>,
HasFieldReference<Lag> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    private String field;
    @XmlAttribute(name="n")
    @XmlJavaTypeAdapter(value=PositiveIntegerAdapter.class)
    @XmlSchemaType(name="positiveInteger")
    @JsonProperty(value="n")
    private Integer n;
    @XmlAttribute(name="aggregate")
    @JsonProperty(value="aggregate")
    @Added(value=Version.PMML_4_4)
    private String aggregate;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="BlockIndicator", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="BlockIndicator")
    private List<BlockIndicator> blockIndicators;
    private static final Integer DEFAULT_N = new PositiveIntegerAdapter().unmarshal("1");
    private static final long serialVersionUID = 67371270L;

    public Lag() {
    }

    @ValueConstructor
    public Lag(@Property(value="field") String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public Lag(Field<?> field) {
        this(field != null ? field.requireName() : null);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.LAG_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public Lag setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    public Integer getN() {
        if (this.n == null) {
            return DEFAULT_N;
        }
        return this.n;
    }

    public Lag setN(@Property(value="n") Integer n) {
        this.n = n;
        return this;
    }

    public String getAggregate() {
        if (this.aggregate == null) {
            return "none";
        }
        return this.aggregate;
    }

    public Lag setAggregate(@Property(value="aggregate") String aggregate) {
        this.aggregate = aggregate;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Lag addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBlockIndicators() {
        return this.blockIndicators != null && !this.blockIndicators.isEmpty();
    }

    public List<BlockIndicator> getBlockIndicators() {
        if (this.blockIndicators == null) {
            this.blockIndicators = new ArrayList<BlockIndicator>();
        }
        return this.blockIndicators;
    }

    public Lag addBlockIndicators(BlockIndicator ... blockIndicators) {
        this.getBlockIndicators().addAll(Arrays.asList(blockIndicators));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasBlockIndicators()) {
                status = PMMLObject.traverse(visitor, this.getBlockIndicators());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

