/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python.testing;

import com.google.common.base.Equivalence;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import org.jpmml.converter.testing.ModelEncoderBatch;
import org.jpmml.evaluator.ResultField;
import org.jpmml.python.CompressedInputStreamStorage;
import org.jpmml.python.PickleUtil;
import org.jpmml.python.Storage;
import org.jpmml.python.testing.PythonEncoderBatchTest;

public abstract class PythonEncoderBatch
extends ModelEncoderBatch {
    public PythonEncoderBatch(String algorithm, String dataset, Predicate<ResultField> columnFilter, Equivalence<Object> equivalence) {
        super(algorithm, dataset, columnFilter, equivalence);
    }

    public abstract PythonEncoderBatchTest getArchiveBatchTest();

    public String getPklPath() {
        return "/pkl/" + this.getAlgorithm() + this.getDataset() + ".pkl";
    }

    public Object loadPickle() throws IOException {
        try (Storage storage = this.openStorage(this.getPklPath());){
            Object object = PickleUtil.unpickle((Storage)storage);
            return object;
        }
    }

    private Storage openStorage(String path) throws IOException {
        InputStream is = this.open(path);
        try {
            return new CompressedInputStreamStorage(is);
        }
        catch (IOException ioe) {
            is.close();
            throw ioe;
        }
    }
}

