/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jpmml.converter.Feature;
import org.jpmml.python.Scope;

public class DataFrameScope
extends Scope {
    private String name = null;
    private List<? extends Feature> columns = null;

    public DataFrameScope(List<? extends Feature> features) {
        this("X", features);
    }

    public DataFrameScope(String name, List<? extends Feature> columns) {
        this.setName(name);
        this.setColumns(columns);
    }

    @Override
    public Feature getFeature(String name) {
        String dataFrameName = this.getName();
        this.checkName(name);
        throw new IllegalArgumentException("Name '" + dataFrameName + "' refers to a row vector. Use an array indexing expression " + dataFrameName + "[<column index>] or " + dataFrameName + "[<column name>] to refer to a specific row vector element");
    }

    @Override
    public Feature getFeature(String name, int columnIndex) {
        List<? extends Feature> features = this.getColumns();
        this.checkName(name);
        if (columnIndex >= 0) {
            if (columnIndex < features.size()) {
                return features.get(columnIndex);
            }
            throw new IllegalArgumentException("Column index " + columnIndex + " not in range " + Arrays.asList(0, features.size()));
        }
        if (-columnIndex <= features.size()) {
            return features.get(features.size() - -columnIndex);
        }
        throw new IllegalArgumentException("Column index " + columnIndex + " not in range " + Arrays.asList(-features.size(), -1));
    }

    @Override
    public Feature getFeature(String name, String columnName) {
        List<? extends Feature> features = this.getColumns();
        this.checkName(name);
        for (Feature feature2 : features) {
            if (!feature2.getName().equals(columnName)) continue;
            return feature2;
        }
        List columnNames = features.stream().map(feature -> "'" + feature.getName() + "'").collect(Collectors.toList());
        throw new IllegalArgumentException("Column name '" + columnName + "' is not in " + columnNames);
    }

    @Override
    public Feature resolveFeature(String name) {
        List<? extends Feature> features = this.getColumns();
        for (Feature feature : features) {
            if (!feature.getName().equals(name)) continue;
            return feature;
        }
        return null;
    }

    private void checkName(String name) {
        String dataFrameName = this.getName();
        if (!dataFrameName.equals(name)) {
            throw new IllegalArgumentException("Name '" + name + "' is not defined");
        }
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public List<? extends Feature> getColumns() {
        return this.columns;
    }

    private void setColumns(List<? extends Feature> columns) {
        this.columns = Objects.requireNonNull(columns);
    }
}

