/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.Feature;
import org.jpmml.python.Scope;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static boolean isString(Expression expression, Scope scope) {
        DataType dataType = ExpressionUtil.getDataType(expression, scope);
        return dataType == DataType.STRING;
    }

    public static DataType getDataType(Expression expression, Scope scope) {
        if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            return constant.getDataType();
        }
        if (expression instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            Feature feature = scope.resolveFeature(fieldRef.getField());
            if (feature == null) {
                return null;
            }
            return feature.getDataType();
        }
        if (expression instanceof Apply) {
            String function;
            Apply apply = (Apply)expression;
            switch (function = apply.getFunction()) {
                case "ceil": 
                case "floor": 
                case "round": {
                    return DataType.INTEGER;
                }
                case "isMissing": 
                case "isNotMissing": 
                case "isValid": 
                case "isNotValid": {
                    return DataType.BOOLEAN;
                }
                case "equal": 
                case "notEqual": 
                case "lessThan": 
                case "lessOrEqual": 
                case "greaterThan": 
                case "greaterOrEqual": {
                    return DataType.BOOLEAN;
                }
                case "and": 
                case "or": {
                    return DataType.BOOLEAN;
                }
                case "not": {
                    return DataType.BOOLEAN;
                }
                case "isIn": 
                case "isNotIn": {
                    return DataType.BOOLEAN;
                }
                case "if": {
                    List expressions = apply.getExpressions();
                    if (expressions.size() > 1) {
                        DataType trueDataType = ExpressionUtil.getDataType((Expression)expressions.get(1), scope);
                        if (expressions.size() > 2) {
                            DataType falseDataType = ExpressionUtil.getDataType((Expression)expressions.get(2), scope);
                            if (Objects.equals(trueDataType, falseDataType)) {
                                return trueDataType;
                            }
                            return null;
                        }
                        return trueDataType;
                    }
                    return null;
                }
                case "concat": 
                case "lowercase": 
                case "substring": 
                case "trimBlanks": 
                case "uppercase": {
                    return DataType.STRING;
                }
                case "stringLength": {
                    return DataType.INTEGER;
                }
                case "replace": {
                    return DataType.STRING;
                }
                case "matches": {
                    return DataType.BOOLEAN;
                }
                case "formatDatetime": 
                case "formatNumber": {
                    return DataType.STRING;
                }
                case "dateDaysSinceYear": 
                case "dateSecondsSinceMidnight": 
                case "dateSecondsSinceYear": {
                    return DataType.INTEGER;
                }
            }
            return null;
        }
        return null;
    }
}

