/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import org.jpmml.python.Token;

public class PythonParserUtil {
    private PythonParserUtil() {
    }

    public static String translateBoolean(String image) {
        return image.toLowerCase();
    }

    public static String translateInt(String image) {
        if (image.endsWith("l") || image.endsWith("L")) {
            return image.substring(0, image.length() - 1);
        }
        return image;
    }

    public static String translateString(String image) {
        return image.substring(1, image.length() - 1);
    }

    public static boolean parseBoolean(Token value) {
        String image = PythonParserUtil.translateBoolean(value.image);
        return Boolean.parseBoolean(image);
    }

    public static double parseFloat(Token value) {
        return Double.parseDouble(value.image);
    }

    public static int parseInt(Token value) {
        return PythonParserUtil.parseInt(null, value);
    }

    public static int parseInt(Token sign, Token value) {
        String image = PythonParserUtil.translateInt(value.image);
        if (sign != null) {
            image = sign.image + image;
        }
        return Integer.parseInt(image);
    }

    public static String parseString(Token value) {
        return PythonParserUtil.translateString(value.image);
    }
}

