/* PredicateTranslator.java */
/* Generated By:JavaCC: Do not edit this line. PredicateTranslator.java */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.List;

import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataType;
import org.dmg.pmml.False;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;

public class PredicateTranslator extends AbstractTranslator implements PythonParserConstants {

        public PredicateTranslator(Scope scope){
                this(new NullProvider());

                setScope(scope);
        }

        public Predicate translatePredicate(String string){
                ReInit(new StringProvider(string));

                Predicate predicate;

                try {
                        predicate = translatePredicateInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException("Python predicate \'" + string + "\' is either invalid or not supported", pe);
                }

                return predicate;
        }

        static
        private SimplePredicate.Operator translateRelationalOperator(Token operator) throws ParseException {

                switch(operator.kind){
                        case EQUAL:
                                return SimplePredicate.Operator.EQUAL;
                        case NOT_EQUAL:
                                return SimplePredicate.Operator.NOT_EQUAL;
                        case LESS_THAN:
                                return SimplePredicate.Operator.LESS_THAN;
                        case LESS_OR_EQUAL:
                                return SimplePredicate.Operator.LESS_OR_EQUAL;
                        case GREATER_THAN:
                                return SimplePredicate.Operator.GREATER_THAN;
                        case GREATER_OR_EQUAL:
                                return SimplePredicate.Operator.GREATER_OR_EQUAL;
                        default:
                                throw new ParseException();
                }
        }

        static
        private Object parseValue(Token value) throws ParseException {

                switch(value.kind){
                        case FALSE:
                        case TRUE:
                                return PythonParserUtil.parseBoolean(value);
                        case INT:
                                return PythonParserUtil.parseInt(value);
                        case FLOAT:
                                return PythonParserUtil.parseFloat(value);
                        case STRING:
                                return PythonParserUtil.parseString(value);
                        default:
                                throw new ParseException();
                }
        }

        static
        private Array createArray(List<?> values){
                DataType dataType = TypeUtil.getDataType(values, DataType.STRING);

                switch(dataType){
                        case INTEGER:
                                return PMMLUtil.createIntArray((List)values);
                        case FLOAT:
                        case DOUBLE:
                                return PMMLUtil.createRealArray((List)values);
                        default:
                                return PMMLUtil.createStringArray(values);
                }
        }

        static
        private SimplePredicate createSimplePredicate(Object left, SimplePredicate.Operator operator, Object right){
                Feature feature = asFeature(left);
                Object value = (right != null ? asValue(right) : null);

                return new SimplePredicate(feature.getName(), operator, value);
        }

        static
        private SimpleSetPredicate createSimpleSetPredicate(Object left, SimpleSetPredicate.BooleanOperator booleanOperator, Object right){
                Feature feature = asFeature(left);
                Array array = (Array)right;

                return new SimpleSetPredicate(feature.getName(), booleanOperator, array);
        }

        static
        private CompoundPredicate createCompoundPredicate(CompoundPredicate.BooleanOperator booleanOperator, Predicate... predicates){
                CompoundPredicate compoundPredicate = new CompoundPredicate(booleanOperator, null)
                        .addPredicates(predicates);

                return compoundPredicate;
        }

        static
        private Feature asFeature(Object object){

                if(object instanceof Feature){
                        return (Feature)object;
                } else

                {
                        throw new IllegalArgumentException("The left-hand side is not a feature reference");
                }
        }

        static
        private Object asValue(Object object){

                if(object instanceof Boolean){
                        return (Boolean)object;
                } else

                if(object instanceof Integer){
                        return (Integer)object;
                } else

                if(object instanceof Double){
                        return (Double)object;
                } else

                if(object instanceof String){
                        return (String)object;
                } else

                {
                        throw new IllegalArgumentException("The right-hand side is not a value (" + object + ")");
                }
        }

        static
        private Object toNegative(Object object) throws ParseException {

                if(object instanceof Boolean){
                        return ((Boolean)object).booleanValue() ? -1 : 0;
                } else

                if(object instanceof Integer){
                        return -((Integer)object).intValue();
                } else

                if(object instanceof Double){
                        return -((Double)object).doubleValue();
                } else

                {
                        throw new ParseException();
                }
        }

  final private Token Sign() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      token = jj_consume_token(PLUS);
      break;
      }
    case MINUS:{
      token = jj_consume_token(MINUS);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return token;
}

  final private Predicate translatePredicateInternal() throws ParseException {Predicate predicate;
    predicate = Predicate();
    jj_consume_token(0);
return predicate;
}

  final private Predicate Predicate() throws ParseException {Predicate predicate;
    predicate = LogicalOrExpression();
return predicate;
}

  final private Predicate LogicalOrExpression() throws ParseException {Predicate left;
        Predicate right;
    left = LogicalAndExpression();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      jj_consume_token(OR);
      right = LogicalAndExpression();
left = createCompoundPredicate(CompoundPredicate.BooleanOperator.OR, left, right);
    }
return left;
}

  final private Predicate LogicalAndExpression() throws ParseException {Predicate left;
        Predicate right;
    left = ComparisonExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      jj_consume_token(AND);
      right = ComparisonExpression();
left = createCompoundPredicate(CompoundPredicate.BooleanOperator.AND, left, right);
    }
return left;
}

  final private Predicate ComparisonExpression() throws ParseException {Object left;
        Token operator = null;
        Object right;
    if (jj_2_1(2147483647)) {
      left = PrimaryExpression();
      jj_consume_token(IS);
      jj_consume_token(NONE);
left = createSimplePredicate(left, SimplePredicate.Operator.IS_MISSING, null);
    } else if (jj_2_2(2147483647)) {
      left = PrimaryExpression();
      jj_consume_token(IS);
      jj_consume_token(NOT);
      jj_consume_token(NONE);
left = createSimplePredicate(left, SimplePredicate.Operator.IS_NOT_MISSING, null);
    } else if (jj_2_3(2147483647)) {
      left = PrimaryExpression();
      jj_consume_token(IN);
      right = ListMakerExpression();
left = createSimpleSetPredicate(left, SimpleSetPredicate.BooleanOperator.IS_IN, right);
    } else if (jj_2_4(2147483647)) {
      left = PrimaryExpression();
      jj_consume_token(NOT);
      jj_consume_token(IN);
      right = ListMakerExpression();
left = createSimpleSetPredicate(left, SimpleSetPredicate.BooleanOperator.IS_NOT_IN, right);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:
      case FALSE:
      case TRUE:
      case INT:
      case FLOAT:
      case NAME:
      case STRING:{
        left = PrimaryExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUAL:
        case NOT_EQUAL:
        case LESS_THAN:
        case LESS_OR_EQUAL:
        case GREATER_THAN:
        case GREATER_OR_EQUAL:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case EQUAL:{
            operator = jj_consume_token(EQUAL);
            break;
            }
          case NOT_EQUAL:{
            operator = jj_consume_token(NOT_EQUAL);
            break;
            }
          case LESS_THAN:{
            operator = jj_consume_token(LESS_THAN);
            break;
            }
          case LESS_OR_EQUAL:{
            operator = jj_consume_token(LESS_OR_EQUAL);
            break;
            }
          case GREATER_THAN:{
            operator = jj_consume_token(GREATER_THAN);
            break;
            }
          case GREATER_OR_EQUAL:{
            operator = jj_consume_token(GREATER_OR_EQUAL);
            break;
            }
          default:
            jj_la1[3] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          right = UnaryExpression();
left = createSimplePredicate(left, translateRelationalOperator(operator), right);
          break;
          }
        default:
          jj_la1[4] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
if((Boolean.FALSE).equals(left)){
                        return False.INSTANCE;
                } else

                if((Boolean.TRUE).equals(left)){
                        return True.INSTANCE;
                }

                return (Predicate)left;
}

  final private Object UnaryExpression() throws ParseException {Token sign = null;
        Object result;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:{
      sign = Sign();
      result = UnaryExpression();
      break;
      }
    case LPAREN:
    case FALSE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:{
      result = PrimaryExpression();
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(sign != null && sign.kind == MINUS){
                        result = toNegative(result);
                }

                return result;
}

  final private Object PrimaryExpression() throws ParseException {Object result;
    if (jj_2_5(2147483647)) {
      result = ArrayIndexingExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:{
        result = NameInvocationExpression();
        break;
        }
      case LPAREN:{
        result = ParenthesizedExpression();
        break;
        }
      case FALSE:
      case TRUE:
      case INT:
      case FLOAT:
      case STRING:{
        result = LiteralExpression();
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return result;
}

  final private Feature ArrayIndexingExpression() throws ParseException {Token name;
        Token sign = null;
        Token column;

        Feature feature;
    if (jj_2_6(2147483647)) {
      name = jj_consume_token(NAME);
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        sign = Sign();
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        ;
      }
      column = jj_consume_token(INT);
      jj_consume_token(RBRACKET);
Scope scope = ensureScope();

                        int colIndex = PythonParserUtil.parseInt(sign, column);

                        feature = scope.getFeature(name.image, colIndex);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:{
        name = jj_consume_token(NAME);
        jj_consume_token(LBRACKET);
        column = jj_consume_token(STRING);
        jj_consume_token(RBRACKET);
Scope scope = ensureScope();

                        String colName = PythonParserUtil.parseString(column);

                        feature = scope.getFeature(name.image, colName);
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return feature;
}

  final private Feature NameInvocationExpression() throws ParseException {Token name;
    name = jj_consume_token(NAME);
Scope scope = ensureScope();

                Feature feature = scope.getFeature(name.image);

                return feature;
}

  final private Predicate ParenthesizedExpression() throws ParseException {Predicate predicate;
    jj_consume_token(LPAREN);
    predicate = Predicate();
    jj_consume_token(RPAREN);
return predicate;
}

  final private Object LiteralExpression() throws ParseException {Token value;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE:{
      value = jj_consume_token(FALSE);
      break;
      }
    case TRUE:{
      value = jj_consume_token(TRUE);
      break;
      }
    case INT:{
      value = jj_consume_token(INT);
      break;
      }
    case FLOAT:{
      value = jj_consume_token(FLOAT);
      break;
      }
    case STRING:{
      value = jj_consume_token(STRING);
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return parseValue(value);
}

  final private Array ListMakerExpression() throws ParseException {Object predicate;

        List<Object> values = new ArrayList<Object>();
    jj_consume_token(LBRACKET);
    predicate = UnaryExpression();
values.add(asValue(predicate));
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      predicate = UnaryExpression();
values.add(asValue(predicate));
    }
    jj_consume_token(RBRACKET);
return createArray(values);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_3R_UnaryExpression_464_9_31()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnaryExpression_465_17_33()) {
    jj_scanpos = xsp;
    if (jj_3R_UnaryExpression_467_17_34()) return true;
    }
    return false;
  }

  private boolean jj_3R_ParenthesizedExpression_554_9_13()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_Predicate_389_9_17()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_Sign_361_9_10()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) return true;
    }
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_null_510_46_5()
 {
    if (jj_3R_Sign_361_9_10()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_442_17_28()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ComparisonExpression_442_45_30()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_511_43_18()
 {
    if (jj_3R_Sign_361_9_10()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_LogicalAndExpression_415_41_23()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_ComparisonExpression_429_9_22()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_439_17_27()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_ListMakerExpression_590_9_29()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_436_17_26()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_ListMakerExpression_590_9_29()) return true;
    return false;
  }

  private boolean jj_3R_NameInvocationExpression_538_9_12()
 {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_433_17_25()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_430_17_24()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_LogicalOrExpression_402_41_21()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_LogicalAndExpression_415_9_20()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_null_510_46_5()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_519_17_16()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(STRING)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_429_9_22()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ComparisonExpression_430_17_24()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_433_17_25()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_436_17_26()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_439_17_27()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonExpression_442_17_28()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_510_17_15()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayIndexingExpression_511_43_18()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_LogicalAndExpression_415_9_20()
 {
    if (jj_3R_ComparisonExpression_429_9_22()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_LogicalAndExpression_415_41_23()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_509_9_11()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayIndexingExpression_510_17_15()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayIndexingExpression_519_17_16()) return true;
    }
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_492_17_9()
 {
    if (jj_3R_LiteralExpression_566_9_14()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_490_17_8()
 {
    if (jj_3R_ParenthesizedExpression_554_9_13()) return true;
    return false;
  }

  private boolean jj_3R_LogicalOrExpression_402_9_19()
 {
    if (jj_3R_LogicalAndExpression_415_9_20()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_LogicalOrExpression_402_41_21()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_488_17_7()
 {
    if (jj_3R_NameInvocationExpression_538_9_12()) return true;
    return false;
  }

  private boolean jj_3R_ListMakerExpression_590_9_29()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_UnaryExpression_464_9_31()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ListMakerExpression_590_88_32()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_485_17_6()
 {
    if (jj_3R_ArrayIndexingExpression_509_9_11()) return true;
    return false;
  }

  private boolean jj_3R_Predicate_389_9_17()
 {
    if (jj_3R_LogicalOrExpression_402_9_19()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_484_9_4()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_485_17_6()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_488_17_7()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_490_17_8()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_492_17_9()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ListMakerExpression_590_88_32()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_UnaryExpression_464_9_31()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonExpression_442_45_30()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) return true;
    }
    }
    }
    }
    }
    if (jj_3R_UnaryExpression_464_9_31()) return true;
    return false;
  }

  private boolean jj_3R_UnaryExpression_467_17_34()
 {
    if (jj_3R_PrimaryExpression_484_9_4()) return true;
    return false;
  }

  private boolean jj_3R_UnaryExpression_465_17_33()
 {
    if (jj_3R_Sign_361_9_10()) return true;
    if (jj_3R_UnaryExpression_464_9_31()) return true;
    return false;
  }

  private boolean jj_3R_LiteralExpression_566_9_14()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) return true;
    }
    }
    }
    }
    return false;
  }

  /** Generated Token Manager. */
  public PythonParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[12];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x60000,0x80,0x100,0xfc00,0xfc00,0x20000020,0x20060020,0x20000020,0x60000,0x0,0x20000000,0x2000000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x3c04,0x3c04,0x3c04,0x0,0x1000,0x2c04,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[6];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public PredicateTranslator(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new PythonParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 12; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public PredicateTranslator(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new PythonParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 12; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public PredicateTranslator(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 12; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 12; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[50];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 12; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 50; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : PythonParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 6; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
