/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.DataType;
import org.dmg.pmml.False;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.python.AbstractTranslator;
import org.jpmml.python.NullProvider;
import org.jpmml.python.ParseException;
import org.jpmml.python.Provider;
import org.jpmml.python.PythonParserConstants;
import org.jpmml.python.PythonParserTokenManager;
import org.jpmml.python.PythonParserUtil;
import org.jpmml.python.Scope;
import org.jpmml.python.SimpleCharStream;
import org.jpmml.python.StringProvider;
import org.jpmml.python.Token;
import org.jpmml.python.TokenMgrException;

public class PredicateTranslator
extends AbstractTranslator
implements PythonParserConstants {
    public PythonParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[6];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private static final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private boolean trace_enabled;

    public PredicateTranslator(Scope scope) {
        this(new NullProvider());
        this.setScope(scope);
    }

    public Predicate translatePredicate(String string) {
        Predicate predicate;
        this.ReInit(new StringProvider(string));
        try {
            predicate = this.translatePredicateInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Python predicate '" + string + "' is either invalid or not supported", pe);
        }
        return predicate;
    }

    private static SimplePredicate.Operator translateRelationalOperator(Token operator) throws ParseException {
        switch (operator.kind) {
            case 10: {
                return SimplePredicate.Operator.EQUAL;
            }
            case 11: {
                return SimplePredicate.Operator.NOT_EQUAL;
            }
            case 12: {
                return SimplePredicate.Operator.LESS_THAN;
            }
            case 13: {
                return SimplePredicate.Operator.LESS_OR_EQUAL;
            }
            case 14: {
                return SimplePredicate.Operator.GREATER_THAN;
            }
            case 15: {
                return SimplePredicate.Operator.GREATER_OR_EQUAL;
            }
        }
        throw new ParseException();
    }

    private static Object parseValue(Token value) throws ParseException {
        switch (value.kind) {
            case 29: 
            case 34: {
                return PythonParserUtil.parseBoolean(value);
            }
            case 42: {
                return PythonParserUtil.parseInt(value);
            }
            case 43: {
                return PythonParserUtil.parseFloat(value);
            }
            case 45: {
                return PythonParserUtil.parseString(value);
            }
        }
        throw new ParseException();
    }

    private static Array createArray(List<?> values) {
        DataType dataType = TypeUtil.getDataType(values, (DataType)DataType.STRING);
        switch (dataType) {
            case INTEGER: {
                return PMMLUtil.createIntArray(values);
            }
            case FLOAT: 
            case DOUBLE: {
                return PMMLUtil.createRealArray(values);
            }
        }
        return PMMLUtil.createStringArray(values);
    }

    private static SimplePredicate createSimplePredicate(Object left, SimplePredicate.Operator operator, Object right) {
        Feature feature = PredicateTranslator.asFeature(left);
        Object value = right != null ? PredicateTranslator.asValue(right) : null;
        return new SimplePredicate(feature.getName(), operator, value);
    }

    private static SimpleSetPredicate createSimpleSetPredicate(Object left, SimpleSetPredicate.BooleanOperator booleanOperator, Object right) {
        Feature feature = PredicateTranslator.asFeature(left);
        Array array = (Array)right;
        return new SimpleSetPredicate(feature.getName(), booleanOperator, array);
    }

    private static CompoundPredicate createCompoundPredicate(CompoundPredicate.BooleanOperator booleanOperator, Predicate ... predicates) {
        CompoundPredicate compoundPredicate = new CompoundPredicate(booleanOperator, null).addPredicates(predicates);
        return compoundPredicate;
    }

    private static Feature asFeature(Object object) {
        if (object instanceof Feature) {
            return (Feature)object;
        }
        throw new IllegalArgumentException("The left-hand side is not a feature reference");
    }

    private static Object asValue(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("The right-hand side is not a value (" + object + ")");
    }

    private static Object toNegative(Object object) throws ParseException {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? -1 : 0;
        }
        if (object instanceof Integer) {
            return -((Integer)object).intValue();
        }
        if (object instanceof Double) {
            return -((Double)object).doubleValue();
        }
        throw new ParseException();
    }

    private final Token Sign() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    private final Predicate translatePredicateInternal() throws ParseException {
        Predicate predicate = this.Predicate();
        this.jj_consume_token(0);
        return predicate;
    }

    private final Predicate Predicate() throws ParseException {
        Predicate predicate = this.LogicalOrExpression();
        return predicate;
    }

    private final Predicate LogicalOrExpression() throws ParseException {
        Predicate left = this.LogicalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            Predicate right = this.LogicalAndExpression();
            left = PredicateTranslator.createCompoundPredicate(CompoundPredicate.BooleanOperator.OR, left, right);
        }
        return left;
    }

    private final Predicate LogicalAndExpression() throws ParseException {
        Predicate left = this.ComparisonExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            Predicate right = this.ComparisonExpression();
            left = PredicateTranslator.createCompoundPredicate(CompoundPredicate.BooleanOperator.AND, left, right);
        }
        return left;
    }

    private final Predicate ComparisonExpression() throws ParseException {
        Object left;
        Token operator = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            left = this.PrimaryExpression();
            this.jj_consume_token(40);
            this.jj_consume_token(33);
            left = PredicateTranslator.createSimplePredicate(left, SimplePredicate.Operator.IS_MISSING, null);
        } else if (this.jj_2_2(Integer.MAX_VALUE)) {
            left = this.PrimaryExpression();
            this.jj_consume_token(40);
            this.jj_consume_token(9);
            this.jj_consume_token(33);
            left = PredicateTranslator.createSimplePredicate(left, SimplePredicate.Operator.IS_NOT_MISSING, null);
        } else if (this.jj_2_3(Integer.MAX_VALUE)) {
            left = this.PrimaryExpression();
            this.jj_consume_token(39);
            Array right = this.ListMakerExpression();
            left = PredicateTranslator.createSimpleSetPredicate(left, SimpleSetPredicate.BooleanOperator.IS_IN, right);
        } else if (this.jj_2_4(Integer.MAX_VALUE)) {
            left = this.PrimaryExpression();
            this.jj_consume_token(9);
            this.jj_consume_token(39);
            Array right = this.ListMakerExpression();
            left = PredicateTranslator.createSimpleSetPredicate(left, SimpleSetPredicate.BooleanOperator.IS_NOT_IN, right);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 29: 
                case 34: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    left = this.PrimaryExpression();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 10: {
                                    operator = this.jj_consume_token(10);
                                    break;
                                }
                                case 11: {
                                    operator = this.jj_consume_token(11);
                                    break;
                                }
                                case 12: {
                                    operator = this.jj_consume_token(12);
                                    break;
                                }
                                case 13: {
                                    operator = this.jj_consume_token(13);
                                    break;
                                }
                                case 14: {
                                    operator = this.jj_consume_token(14);
                                    break;
                                }
                                case 15: {
                                    operator = this.jj_consume_token(15);
                                    break;
                                }
                                default: {
                                    this.jj_la1[3] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            Object right = this.UnaryExpression();
                            left = PredicateTranslator.createSimplePredicate(left, PredicateTranslator.translateRelationalOperator(operator), right);
                            break block0;
                        }
                    }
                    this.jj_la1[4] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (Boolean.FALSE.equals(left)) {
            return False.INSTANCE;
        }
        if (Boolean.TRUE.equals(left)) {
            return True.INSTANCE;
        }
        return (Predicate)left;
    }

    private final Object UnaryExpression() throws ParseException {
        Object result;
        Token sign = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: 
            case 18: {
                sign = this.Sign();
                result = this.UnaryExpression();
                break;
            }
            case 5: 
            case 29: 
            case 34: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                result = this.PrimaryExpression();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (sign != null && sign.kind == 18) {
            result = PredicateTranslator.toNegative(result);
        }
        return result;
    }

    private final Object PrimaryExpression() throws ParseException {
        Object result;
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            result = this.ArrayIndexingExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 44: {
                    result = this.NameInvocationExpression();
                    break;
                }
                case 5: {
                    result = this.ParenthesizedExpression();
                    break;
                }
                case 29: 
                case 34: 
                case 42: 
                case 43: 
                case 45: {
                    result = this.LiteralExpression();
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return result;
    }

    private final Feature ArrayIndexingExpression() throws ParseException {
        Feature feature;
        Token sign = null;
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            Token name = this.jj_consume_token(44);
            this.jj_consume_token(23);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: 
                case 18: {
                    sign = this.Sign();
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                }
            }
            Token column = this.jj_consume_token(42);
            this.jj_consume_token(24);
            Scope scope = this.ensureScope();
            int colIndex = PythonParserUtil.parseInt(sign, column);
            feature = scope.getFeature(name.image, colIndex);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 44: {
                    Token name = this.jj_consume_token(44);
                    this.jj_consume_token(23);
                    Token column = this.jj_consume_token(45);
                    this.jj_consume_token(24);
                    Scope scope = this.ensureScope();
                    String colName = PythonParserUtil.parseString(column);
                    feature = scope.getFeature(name.image, colName);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return feature;
    }

    private final Feature NameInvocationExpression() throws ParseException {
        Token name = this.jj_consume_token(44);
        Scope scope = this.ensureScope();
        Feature feature = scope.getFeature(name.image);
        return feature;
    }

    private final Predicate ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(5);
        Predicate predicate = this.Predicate();
        this.jj_consume_token(6);
        return predicate;
    }

    private final Object LiteralExpression() throws ParseException {
        Token value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29: {
                value = this.jj_consume_token(29);
                break;
            }
            case 34: {
                value = this.jj_consume_token(34);
                break;
            }
            case 42: {
                value = this.jj_consume_token(42);
                break;
            }
            case 43: {
                value = this.jj_consume_token(43);
                break;
            }
            case 45: {
                value = this.jj_consume_token(45);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return PredicateTranslator.parseValue(value);
    }

    private final Array ListMakerExpression() throws ParseException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.jj_consume_token(23);
        Object predicate = this.UnaryExpression();
        values.add(PredicateTranslator.asValue(predicate));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(25);
            predicate = this.UnaryExpression();
            values.add(PredicateTranslator.asValue(predicate));
        }
        this.jj_consume_token(24);
        return PredicateTranslator.createArray(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    private boolean jj_3R_UnaryExpression_464_9_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_UnaryExpression_465_17_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_UnaryExpression_467_17_34()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_ParenthesizedExpression_554_9_13() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_3R_Predicate_389_9_17()) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3_4() {
        if (this.jj_3R_PrimaryExpression_484_9_4()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_Sign_361_9_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(18)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        if (this.jj_3R_PrimaryExpression_484_9_4()) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_null_510_46_5() {
        return this.jj_3R_Sign_361_9_10();
    }

    private boolean jj_3_2() {
        if (this.jj_3R_PrimaryExpression_484_9_4()) {
            return true;
        }
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_ComparisonExpression_442_17_28() {
        if (this.jj_3R_PrimaryExpression_484_9_4()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ComparisonExpression_442_45_30()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_ArrayIndexingExpression_511_43_18() {
        return this.jj_3R_Sign_361_9_10();
    }

    private boolean jj_3_1() {
        if (this.jj_3R_PrimaryExpression_484_9_4()) {
            return true;
        }
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_LogicalAndExpression_415_41_23() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_ComparisonExpression_429_9_22();
    }

    private boolean jj_3R_ComparisonExpression_439_17_27() {
        if (this.jj_3R_PrimaryExpression_484_9_4()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_3R_ListMakerExpression_590_9_29();
    }

    private boolean jj_3R_ComparisonExpression_436_17_26() {
        if (this.jj_3R_PrimaryExpression_484_9_4()) {
            return true;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_3R_ListMakerExpression_590_9_29();
    }

    private boolean jj_3R_NameInvocationExpression_538_9_12() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3R_ComparisonExpression_433_17_25() {
        if (this.jj_3R_PrimaryExpression_484_9_4()) {
            return true;
        }
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_ComparisonExpression_430_17_24() {
        if (this.jj_3R_PrimaryExpression_484_9_4()) {
            return true;
        }
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_LogicalOrExpression_402_41_21() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_LogicalAndExpression_415_9_20();
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_null_510_46_5()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_ArrayIndexingExpression_519_17_16() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_scan_token(45)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_ComparisonExpression_429_9_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ComparisonExpression_430_17_24()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_ComparisonExpression_433_17_25()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_ComparisonExpression_436_17_26()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_ComparisonExpression_439_17_27()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_ComparisonExpression_442_17_28()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_ArrayIndexingExpression_510_17_15() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ArrayIndexingExpression_511_43_18()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(42)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_LogicalAndExpression_415_9_20() {
        Token xsp;
        if (this.jj_3R_ComparisonExpression_429_9_22()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_LogicalAndExpression_415_41_23());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_ArrayIndexingExpression_509_9_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_ArrayIndexingExpression_510_17_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_ArrayIndexingExpression_519_17_16()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_PrimaryExpression_492_17_9() {
        return this.jj_3R_LiteralExpression_566_9_14();
    }

    private boolean jj_3R_PrimaryExpression_490_17_8() {
        return this.jj_3R_ParenthesizedExpression_554_9_13();
    }

    private boolean jj_3R_LogicalOrExpression_402_9_19() {
        Token xsp;
        if (this.jj_3R_LogicalAndExpression_415_9_20()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_LogicalOrExpression_402_41_21());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_PrimaryExpression_488_17_7() {
        return this.jj_3R_NameInvocationExpression_538_9_12();
    }

    private boolean jj_3R_ListMakerExpression_590_9_29() {
        Token xsp;
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_3R_UnaryExpression_464_9_31()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_ListMakerExpression_590_88_32());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_PrimaryExpression_485_17_6() {
        return this.jj_3R_ArrayIndexingExpression_509_9_11();
    }

    private boolean jj_3R_Predicate_389_9_17() {
        return this.jj_3R_LogicalOrExpression_402_9_19();
    }

    private boolean jj_3R_PrimaryExpression_484_9_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_PrimaryExpression_485_17_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_PrimaryExpression_488_17_7()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_PrimaryExpression_490_17_8()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_PrimaryExpression_492_17_9()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_ListMakerExpression_590_88_32() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_UnaryExpression_464_9_31();
    }

    private boolean jj_3R_ComparisonExpression_442_45_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(11)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(12)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(13)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(14)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(15)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_UnaryExpression_464_9_31();
    }

    private boolean jj_3R_UnaryExpression_467_17_34() {
        return this.jj_3R_PrimaryExpression_484_9_4();
    }

    private boolean jj_3R_UnaryExpression_465_17_33() {
        if (this.jj_3R_Sign_361_9_10()) {
            return true;
        }
        return this.jj_3R_UnaryExpression_464_9_31();
    }

    private boolean jj_3R_LiteralExpression_566_9_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(29)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(34)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(42)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(43)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(45)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{393216, 128, 256, 64512, 64512, 0x20000020, 0x20060020, 0x20000020, 393216, 0, 0x20000000, 0x2000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 15364, 15364, 15364, 0, 4096, 11268, 0};
    }

    public PredicateTranslator(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PythonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PredicateTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new PythonParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PredicateTranslator(PythonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PythonParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[50];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 12; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 50; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : PythonParserTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 6; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PredicateTranslator.jj_la1_init_0();
        PredicateTranslator.jj_la1_init_1();
        jj_ls = new LookaheadSuccess();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

