/*
 * Decompiled with CFR 0.152.
 */
package pandas.core;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import numpy.core.NDArray;
import org.jpmml.python.HasArray;
import org.jpmml.python.PythonObject;

public class MaskedArray
extends PythonObject
implements HasArray {
    public MaskedArray(String module, String name) {
        super(module, name);
    }

    @Override
    public List<?> getArrayContent() {
        NDArray data = this.getData();
        NDArray mask = this.getMask();
        final List<?> dataValues = data.getArrayContent();
        final List<?> maskValues = mask.getArrayContent();
        AbstractList<Object> result = new AbstractList<Object>(){

            @Override
            public int size() {
                return dataValues.size();
            }

            @Override
            public Object get(int index) {
                Boolean mask = (Boolean)maskValues.get(index);
                if (mask.booleanValue()) {
                    return null;
                }
                return dataValues.get(index);
            }
        };
        return result;
    }

    @Override
    public int[] getArrayShape() {
        int[] maskShape;
        NDArray data = this.getData();
        NDArray mask = this.getMask();
        int[] dataShape = data.getArrayShape();
        if (!Arrays.equals(dataShape, maskShape = mask.getArrayShape())) {
            throw new IllegalArgumentException("Expected matching array shapes, got " + Arrays.toString(dataShape) + " and " + Arrays.toString(maskShape));
        }
        return dataShape;
    }

    @Override
    public Object getArrayType() {
        Object dtype = this.getDType();
        if (dtype == null) {
            NDArray data = this.getData();
            return data.getDescr();
        }
        return dtype;
    }

    public NDArray getData() {
        return this.get("_data", NDArray.class);
    }

    public Object getDType() {
        return this.get("_dtype");
    }

    public NDArray getMask() {
        return this.get("_mask", NDArray.class);
    }
}

