/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.Scope;

public class DataFrameScope
extends Scope {
    private String variableName = null;
    private List<? extends Feature> columns = null;

    public DataFrameScope(List<? extends Feature> columns) {
        this("X", columns, null);
    }

    public DataFrameScope(String variableName, List<? extends Feature> columns) {
        this(variableName, columns, null);
    }

    public DataFrameScope(String variableName, List<? extends Feature> columns, PMMLEncoder encoder) {
        super(encoder);
        this.setVariableName(variableName);
        this.setColumns(columns);
    }

    @Override
    public Feature getFeature(String name) {
        String variableName = this.getVariableName();
        if (variableName.equals(name)) {
            throw new IllegalArgumentException("Name '" + variableName + "' refers to a row vector. Use an array indexing expression " + variableName + "[<column index>] or " + variableName + "[<column name>] to refer to a specific row vector element");
        }
        Feature feature = this.resolveFeature(name);
        if (feature != null) {
            return feature;
        }
        throw new IllegalArgumentException("Name '" + name + "' is not defined");
    }

    @Override
    public Feature getFeature(String name, int columnIndex) {
        List<? extends Feature> columns = this.getColumns();
        this.checkIsDataFrame(name);
        if (columnIndex >= 0) {
            if (columnIndex < columns.size()) {
                return columns.get(columnIndex);
            }
            throw new IllegalArgumentException("Column index " + columnIndex + " not in range " + Arrays.asList(0, columns.size()));
        }
        if (-columnIndex <= columns.size()) {
            return columns.get(columns.size() - -columnIndex);
        }
        throw new IllegalArgumentException("Column index " + columnIndex + " not in range " + Arrays.asList(-columns.size(), -1));
    }

    @Override
    public Feature getFeature(String name, String columnName) {
        List<? extends Feature> columns = this.getColumns();
        this.checkIsDataFrame(name);
        for (Feature feature2 : columns) {
            if (!feature2.getName().equals(columnName)) continue;
            return feature2;
        }
        List columnNames = columns.stream().map(feature -> "'" + feature.getName() + "'").collect(Collectors.toList());
        throw new IllegalArgumentException("Column name '" + columnName + "' is not in " + columnNames);
    }

    @Override
    public Feature resolveFeature(String name) {
        List<? extends Feature> columns = this.getColumns();
        for (Feature feature : columns) {
            if (!feature.getName().equals(name)) continue;
            return feature;
        }
        return super.resolveFeature(name);
    }

    private void checkIsDataFrame(String name) {
        String variableName = this.getVariableName();
        if (!variableName.equals(name)) {
            throw new IllegalArgumentException("Name '" + name + "' is not defined");
        }
    }

    public String getVariableName() {
        return this.variableName;
    }

    private void setVariableName(String variableName) {
        this.variableName = Objects.requireNonNull(variableName);
    }

    public List<? extends Feature> getColumns() {
        return this.columns;
    }

    private void setColumns(List<? extends Feature> columns) {
        this.columns = Objects.requireNonNull(columns);
    }
}

