/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Expression;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.Identifiable;

public class FunctionUtil {
    private FunctionUtil() {
    }

    public static String canonicalizeModule(String module) {
        if ("".equals(module)) {
            return "builtins";
        }
        String[] parts = module.split("\\.");
        switch (parts[0]) {
            case "np": {
                parts[0] = "numpy";
                break;
            }
            case "pd": {
                parts[0] = "pandas";
                break;
            }
            case "sp": {
                parts[0] = "scipy";
                break;
            }
            default: {
                return module;
            }
        }
        return Arrays.stream(parts).collect(Collectors.joining("."));
    }

    public static Apply encodeFunction(Identifiable identifiable, List<Expression> expressions) {
        return FunctionUtil.encodeFunction(identifiable.getModule(), identifiable.getName(), expressions);
    }

    public static Apply encodeFunction(String function, List<Expression> expressions) {
        String name;
        String module;
        int dot = function.lastIndexOf(46);
        if (dot > -1) {
            module = function.substring(0, dot);
            name = function.substring(dot + 1);
        } else {
            module = "";
            name = function;
        }
        module = FunctionUtil.canonicalizeModule(module);
        return FunctionUtil.encodeFunction(module, name, expressions);
    }

    public static Apply encodeFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("builtins")) {
            return FunctionUtil.encodePythonFunction(module, name, expressions);
        }
        if (module.equals("math")) {
            return FunctionUtil.encodeMathFunction(module, name, expressions);
        }
        if (module.equals("numpy") || module.startsWith("numpy.")) {
            return FunctionUtil.encodeNumpyFunction(module, name, expressions);
        }
        if (module.equals("pandas") || module.startsWith("pandas.")) {
            return FunctionUtil.encodePandasFunction(module, name, expressions);
        }
        if (module.equals("scipy") || module.startsWith("scipy.")) {
            return FunctionUtil.encodeScipyFunction(module, name, expressions);
        }
        throw new IllegalArgumentException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodePythonFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("builtins")) {
            switch (name) {
                case "len": {
                    return PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
            }
        }
        throw new IllegalArgumentException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodeMathFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("math")) {
            switch (name) {
                case "ceil": {
                    return PMMLUtil.createApply((String)"ceil", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "exp": {
                    return PMMLUtil.createApply((String)"exp", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "expm1": {
                    return PMMLUtil.createApply((String)"expm1", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "fabs": {
                    return PMMLUtil.createApply((String)"abs", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "floor": {
                    return PMMLUtil.createApply((String)"floor", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "isnan": {
                    return PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "log": {
                    return PMMLUtil.createApply((String)"ln", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "logp1": {
                    return PMMLUtil.createApply((String)"ln1p", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "log10": {
                    return PMMLUtil.createApply((String)"log10", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "pow": {
                    return PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
                }
                case "sqrt": {
                    return PMMLUtil.createApply((String)"sqrt", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "trunc": {
                    return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"lessThan", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)0)}), PMMLUtil.createApply((String)"ceil", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)}), PMMLUtil.createApply((String)"floor", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)})});
                }
            }
        }
        throw new IllegalArgumentException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodeNumpyFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("numpy") || module.startsWith("numpy.")) {
            switch (name) {
                case "absolute": {
                    return PMMLUtil.createApply((String)"abs", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "arccos": {
                    return PMMLUtil.createApply((String)"acos", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "arcsin": {
                    return PMMLUtil.createApply((String)"asin", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "arctan": {
                    return PMMLUtil.createApply((String)"atan", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "arctan2": {
                    return PMMLUtil.createApply((String)"x-atan2", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
                }
                case "ceil": {
                    return PMMLUtil.createApply((String)"ceil", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "clip": {
                    return PMMLUtil.createApply((String)"min", (Expression[])new Expression[]{PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 3, 0), FunctionUtil.getElement(expressions, 3, 1)}), FunctionUtil.getElement(expressions, 3, 2)});
                }
                case "cos": {
                    return PMMLUtil.createApply((String)"cos", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "cosh": {
                    return PMMLUtil.createApply((String)"cosh", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "degrees": 
                case "rad2deg": {
                    return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)57.29577951308232)});
                }
                case "exp": {
                    return PMMLUtil.createApply((String)"exp", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "expm1": {
                    return PMMLUtil.createApply((String)"expm1", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "floor": {
                    return PMMLUtil.createApply((String)"floor", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "fmax": {
                    return PMMLUtil.createApply((String)"max", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
                }
                case "fmin": {
                    return PMMLUtil.createApply((String)"min", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
                }
                case "hypot": {
                    return PMMLUtil.createApply((String)"hypot", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "isnan": {
                    return PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "log": {
                    return PMMLUtil.createApply((String)"ln", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "logical_and": {
                    return PMMLUtil.createApply((String)"and", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
                }
                case "logical_not": {
                    return PMMLUtil.createApply((String)"not", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "logical_or": {
                    return PMMLUtil.createApply((String)"or", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
                }
                case "log1p": {
                    return PMMLUtil.createApply((String)"ln1p", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "log10": {
                    return PMMLUtil.createApply((String)"log10", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "negative": {
                    return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)-1), FunctionUtil.getOnlyElement(expressions)});
                }
                case "power": {
                    return PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 2, 0), FunctionUtil.getElement(expressions, 2, 1)});
                }
                case "radians": 
                case "deg2rad": {
                    return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)(Math.PI / 180))});
                }
                case "reciprocal": {
                    return PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)1), FunctionUtil.getOnlyElement(expressions)});
                }
                case "rint": {
                    return PMMLUtil.createApply((String)"rint", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "sign": {
                    return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"lessThan", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)0)}), PMMLUtil.createConstant((Number)-1), PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"greaterThan", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)0)}), PMMLUtil.createConstant((Number)1), PMMLUtil.createConstant((Number)0)})});
                }
                case "sin": {
                    return PMMLUtil.createApply((String)"sin", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "sinh": {
                    return PMMLUtil.createApply((String)"sinh", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "sqrt": {
                    return PMMLUtil.createApply((String)"sqrt", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "square": {
                    return PMMLUtil.createApply((String)"pow", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createConstant((Number)2)});
                }
                case "tan": {
                    return PMMLUtil.createApply((String)"tan", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "tanh": {
                    return PMMLUtil.createApply((String)"tanh", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "where": {
                    return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{FunctionUtil.getElement(expressions, 3, 0), FunctionUtil.getElement(expressions, 3, 1), FunctionUtil.getElement(expressions, 3, 2)});
                }
            }
        }
        throw new IllegalArgumentException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodePandasFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("pandas")) {
            switch (name) {
                case "isna": 
                case "isnull": {
                    return PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
                case "notna": 
                case "notnull": {
                    return PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions)});
                }
            }
        }
        throw new IllegalArgumentException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    public static Apply encodeScipyFunction(String module, String name, List<Expression> expressions) {
        if (module.equals("scipy.special")) {
            switch (name) {
                case "expit": {
                    return PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)1), PMMLUtil.createApply((String)"+", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)1), PMMLUtil.createApply((String)"exp", (Expression[])new Expression[]{PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)-1), FunctionUtil.getOnlyElement(expressions)})})})});
                }
                case "logit": {
                    return PMMLUtil.createApply((String)"ln", (Expression[])new Expression[]{PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{FunctionUtil.getOnlyElement(expressions), PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)1), FunctionUtil.getOnlyElement(expressions)})})});
                }
            }
        }
        throw new IllegalArgumentException("Function '" + FunctionUtil.formatFunction(module, name) + "' is not supported");
    }

    private static String formatFunction(String module, String name) {
        return module + "." + name;
    }

    private static Expression getOnlyElement(List<Expression> expressions) {
        ClassDictUtil.checkSize(1, expressions);
        return expressions.get(0);
    }

    private static Expression getElement(List<Expression> expressions, int expectedSize, int index) {
        ClassDictUtil.checkSize(expectedSize, expressions);
        return expressions.get(index);
    }
}

