/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.jpmml.python.CompressedInputStreamStorage;
import org.jpmml.python.FileStorage;
import org.jpmml.python.InputStreamStorage;
import org.jpmml.python.Storage;

public class StorageUtil {
    private StorageUtil() {
    }

    public static Storage createStorage(File file) throws IOException {
        PushbackInputStream is = new PushbackInputStream(new FileInputStream(file), 2);
        CompressedInputStreamStorage.Type type = CompressedInputStreamStorage.detectType(is);
        if (type != null) {
            return new CompressedInputStreamStorage(is);
        }
        is.close();
        return new FileStorage(file);
    }

    public static Storage createStorage(InputStream is) throws IOException {
        return StorageUtil.createStorage(new PushbackInputStream(is, 2));
    }

    public static Storage createStorage(PushbackInputStream is) throws IOException {
        CompressedInputStreamStorage.Type type = CompressedInputStreamStorage.detectType(is);
        if (type != null) {
            return new CompressedInputStreamStorage(is);
        }
        return new InputStreamStorage(is);
    }
}

