/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import java.util.List;
import java.util.Objects;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.BlockScope;
import org.jpmml.python.FunctionDef;

public class FunctionDefScope
extends BlockScope {
    private FunctionDef functionDef = null;

    public FunctionDefScope(FunctionDef functionDef, List<? extends Feature> variables) {
        this(functionDef, variables, null);
    }

    public FunctionDefScope(FunctionDef functionDef, List<? extends Feature> variables, PMMLEncoder encoder) {
        super(variables, encoder);
        this.setFunctionDef(functionDef);
    }

    @Override
    public Feature resolveFeature(String name) {
        List<? extends Feature> variables = this.getVariables();
        int index = this.getParameterIndex(name);
        if (index > -1) {
            return variables.get(index);
        }
        return null;
    }

    public int getParameterIndex(String name) {
        FunctionDef functionDef = this.getFunctionDef();
        List<FunctionDef.Parameter> parameters = functionDef.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            FunctionDef.Parameter parameter = parameters.get(i);
            if (!parameter.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public FunctionDef getFunctionDef() {
        return this.functionDef;
    }

    private void setFunctionDef(FunctionDef functionDef) {
        this.functionDef = Objects.requireNonNull(functionDef);
    }
}

