/* ExpressionTranslator.java */
/* Generated By:JavaCC: Do not edit this line. ExpressionTranslator.java */
package org.jpmml.python;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Iterables;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.PMMLFunctions;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;

public class ExpressionTranslator extends AbstractTranslator implements PythonParserConstants {

        private Deque<String> indents = new ArrayDeque<>();

        private Map<String, FieldRef> variableMap = new LinkedHashMap<>();


        public ExpressionTranslator(Scope scope){
                this(new NullProvider());

                setScope(scope);
        }

        public DerivedField translateDef(String string){
                ReInit(new StringProvider(ensureTerminator(string)));

                DerivedField derivedField;

                try {
                        derivedField = translateDefInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException("Python function definition \'" + toSingleLine(string) + "\' is either invalid or not supported", pe);
                }

                return derivedField;
        }

        public Expression translateStatement(String string){
                return translateStatement(string, true);
        }

        public Expression translateStatement(String string, boolean compact){
                ReInit(new StringProvider(ensureTerminator(string)));

                Expression statement;

                try {
                        statement = translateStatementInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException("Python statement \'" + toSingleLine(string) + "\' is either invalid or not supported", pe);
                }

                if(compact){
                        statement = compact(statement);
                }

                return statement;
        }

        public Expression translateExpression(String string){
                return translateExpression(string, true);
        }

        public Expression translateExpression(String string, boolean compact){
                ReInit(new StringProvider(string));

                Expression expression;

                try {
                        expression = translateExpressionInternal();
                } catch(ParseException pe){
                        throw new IllegalArgumentException("Python expression \'" + toSingleLine(string) + "\' is either invalid or not supported", pe);
                }

                if(compact){
                        expression = compact(expression);
                }

                return expression;
        }

        public Constant encodeConstant(String dottedName){

                switch(dottedName){
                        case "math.e":
                        case "numpy.e":
                                return PMMLUtil.createConstant(Math.E, DataType.DOUBLE);
                        case "numpy.NZERO":
                                return PMMLUtil.createConstant(-0.0d, DataType.DOUBLE);
                        case "math.pi":
                        case "numpy.pi":
                                return PMMLUtil.createConstant(Math.PI, DataType.DOUBLE);
                        case "numpy.PZERO":
                                return PMMLUtil.createConstant(0.0, DataType.DOUBLE);
                        default:
                                break;
                }

                switch(dottedName){
                        // Math
                        case "math.nan":
                        // Numpy
                        case "numpy.nan":
                        case "numpy.NaN":
                        case "numpy.NAN":
                        // Pandas
                        case "pandas.NA":
                        case "pandas.NaT":
                                return PMMLUtil.createMissingConstant();
                        default:
                                break;
                }

                throw new IllegalArgumentException("Constant \'" + dottedName + "\' is not supported");
        }

        private String getIndent() throws ParseException {
                Token nextToken = getToken(1);

                return PythonParserUtil.getWhitespace(nextToken);
        }

        private void checkIndent(String indent) throws ParseException {
                String expectedIndent = this.indents.peek();

                if(!(indent).equals(expectedIndent)){
                        throw new ParseException("Unexpected indent");
                }
        }

        static
        public Expression compact(Expression expression){
                ExpressionCompactor expressionCompactor = new ExpressionCompactor();

                expressionCompactor.applyTo(expression);

                return expression;
        }

        static
        private String translateRelationalOperator(Token operator) throws ParseException {

                switch(operator.kind){
                        case EQUAL:
                                return PMMLFunctions.EQUAL;
                        case NOT_EQUAL:
                                return PMMLFunctions.NOTEQUAL;
                        case LESS_THAN:
                                return PMMLFunctions.LESSTHAN;
                        case LESS_OR_EQUAL:
                                return PMMLFunctions.LESSOREQUAL;
                        case GREATER_THAN:
                                return PMMLFunctions.GREATERTHAN;
                        case GREATER_OR_EQUAL:
                                return PMMLFunctions.GREATEROREQUAL;
                        default:
                                throw new ParseException();
                }
        }

        static
        private String translateArithmeticOperator(Token operator){

                switch(operator.kind){
                        case MODULO:
                                return PMMLFunctions.MODULO;
                        default:
                                return operator.image;
                }
        }

        static
        private Apply translateTrailerFunction(Expression expression, String name, List<Expression> arguments){

                if(("startswith").equals(name) || ("endswith").equals(name)){
                        ClassDictUtil.checkSize(1, arguments);

                        Expression argument = arguments.get(0);
                        if(!(argument instanceof Constant)){
                                throw new IllegalArgumentException();
                        }

                        Constant constant = (Constant)argument;
                        if(constant.getDataType() != DataType.STRING){
                                throw new IllegalArgumentException();
                        }

                        String value = (String)constant.getValue();

                        switch(name){
                                case "startswith":
                                        return PMMLUtil.createApply(PMMLFunctions.EQUAL,
                                                translateStringSlice(expression, 0, value.length()),
                                                constant
                                        );
                                case "endswith":
                                        return PMMLUtil.createApply(PMMLFunctions.EQUAL,
                                                translateStringSlice(expression, -value.length(), null),
                                                constant
                                        );
                                default:
                                        break;
                        }
                } else

                if(("lower").equals(name) || ("upper").equals(name)){
                        ClassDictUtil.checkSize(0, arguments);

                        switch(name){
                                case "lower":
                                        return PMMLUtil.createApply(PMMLFunctions.LOWERCASE, expression);
                                case "upper":
                                        return PMMLUtil.createApply(PMMLFunctions.UPPERCASE, expression);
                                default:
                                        break;
                        }
                } else

                if(("strip").equals(name)){
                        ClassDictUtil.checkSize(0, arguments);

                        switch(name){
                                case "strip":
                                        return PMMLUtil.createApply(PMMLFunctions.TRIMBLANKS, expression);
                                default:
                                        break;
                        }
                }

                throw new IllegalArgumentException("Function \'" + name + "\' is not supported");
        }

        static
        private Expression translateStringSlice(Expression expression, Integer startPos, Integer stopPos){

                if(startPos == null && stopPos == null){
                        return expression;
                }

                Expression offsetExpression;

                if(startPos != null && startPos >= 0){
                        offsetExpression = PMMLUtil.createConstant(startPos + 1, DataType.INTEGER);
                } else

                if(startPos != null && startPos < 0){
                        offsetExpression = PMMLUtil.createApply(PMMLFunctions.MAX,
                                PMMLUtil.createApply(PMMLFunctions.SUBTRACT,
                                        PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                        PMMLUtil.createConstant((-startPos) - 1, DataType.INTEGER)
                                ),
                                PMMLUtil.createConstant(1, DataType.INTEGER)
                        );
                } else

                {
                        offsetExpression = PMMLUtil.createConstant(1, DataType.INTEGER);
                } // End if

                Expression lengthExpression;

                if(stopPos != null && stopPos >= 0){

                        if(startPos != null && startPos >= 0){
                                lengthExpression = PMMLUtil.createConstant(Math.max(stopPos - startPos, 0), DataType.INTEGER);
                        } else

                        if(startPos != null && startPos < 0){
                                lengthExpression = PMMLUtil.createConstant(0, DataType.INTEGER);
                        } else

                        {
                                lengthExpression = PMMLUtil.createConstant(stopPos, DataType.INTEGER);
                        }
                } else

                if(stopPos != null && stopPos < 0){

                        if(startPos != null && startPos >= 0){
                                lengthExpression = PMMLUtil.createApply(PMMLFunctions.MAX,
                                        PMMLUtil.createApply(PMMLFunctions.SUBTRACT,
                                                PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                                PMMLUtil.createConstant(startPos + (-stopPos))
                                        ),
                                        PMMLUtil.createConstant(0, DataType.INTEGER)
                                );
                        } else

                        if(startPos != null && startPos < 0){
                                lengthExpression = PMMLUtil.createConstant(Math.max(stopPos - startPos, 0), DataType.INTEGER);
                        } else

                        {
                                lengthExpression = PMMLUtil.createApply(PMMLFunctions.MAX,
                                        PMMLUtil.createApply(PMMLFunctions.SUBTRACT,
                                                PMMLUtil.createApply(PMMLFunctions.STRINGLENGTH, expression),
                                                PMMLUtil.createConstant(-stopPos)
                                        ),
                                        PMMLUtil.createConstant(0, DataType.INTEGER)
                                );
                        }
                } else

                {
                        lengthExpression = PMMLUtil.createConstant(Integer.MAX_VALUE, DataType.INTEGER);
                }

                return PMMLUtil.createApply(PMMLFunctions.SUBSTRING, expression, offsetExpression, lengthExpression);
        }

        static
        private String ensureTerminator(String string){

                if(string.endsWith("\n")){

                        if(!string.endsWith("\n\n")){
                                string += "\n";
                        }
                }

                return string;
        }

        static
        private Expression getOnlyStatement(List<Expression> statements){

                for(int i = 0; i < statements.size(); i++){
                        Expression statement = statements.get(i);

                        if(statement != null){
                                statements = statements.subList(i, statements.size());

                                break;
                        }
                }

                return Iterables.getOnlyElement(statements);
        }

        static
        private class Block extends ArrayList<Expression> {

                private Block(List<Expression> statements){
                        super(statements);
                }
        }

  final private Token String() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING:{
      token = jj_consume_token(STRING);
      break;
      }
    case MULTILINE_STRING:{
      token = jj_consume_token(MULTILINE_STRING);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return token;
}

  final private Token Sign() throws ParseException {Token token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      token = jj_consume_token(PLUS);
      break;
      }
    case MINUS:{
      token = jj_consume_token(MINUS);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return token;
}

  final private String DottedName() throws ParseException {Token name;
        StringBuilder sb = new StringBuilder();
    name = jj_consume_token(NAME);
sb.append(name.image);
    label_1:
    while (true) {
      if (jj_2_1(2147483647)) {
        ;
      } else {
        break label_1;
      }
      jj_consume_token(DOT);
      name = jj_consume_token(NAME);
sb.append('.').append(name.image);
    }
return sb.toString();
}

  final private String CanonicalizedDottedName() throws ParseException {String dottedName;
    dottedName = DottedName();
return canonicalizeDottedName(dottedName);
}

  final private DerivedField translateDefInternal() throws ParseException {DerivedField derivedField;
    derivedField = Def();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEWLINE:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      jj_consume_token(NEWLINE);
    }
    jj_consume_token(0);
return derivedField;
}

  final private Expression translateStatementInternal() throws ParseException {Expression expression;
    expression = Statement();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEWLINE:{
        ;
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_3;
      }
      jj_consume_token(NEWLINE);
    }
    jj_consume_token(0);
return expression;
}

  final private Expression translateExpressionInternal() throws ParseException {Expression expression;
    expression = Expression();
    jj_consume_token(0);
return expression;
}

  final private DerivedField Def() throws ParseException {Token name;
        List<Token> parameters;
        Block block;
this.variableMap.clear();
    jj_consume_token(DEF);
    name = jj_consume_token(NAME);
    parameters = Parameters();
    jj_consume_token(COLON);
    block = Block();
this.variableMap.clear();

                return createDerivedField(name.image, getOnlyStatement(block));
}

  final private List<Token> Parameters() throws ParseException {Token name;
        List<Token> names = new ArrayList();
    if (jj_2_2(2147483647)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        name = jj_consume_token(NAME);
names.add(name);
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            break label_4;
          }
          jj_consume_token(COMMA);
          name = jj_consume_token(NAME);
names.add(name);
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return names;
}

  final private Block Block() throws ParseException {List<Expression> statements;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NEWLINE:{
      label_5:
      while (true) {
        jj_consume_token(NEWLINE);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          break label_5;
        }
      }
      Indent();
      statements = Statements();
      Dedent();
      break;
      }
    case LPAREN:
    case NOT:
    case PLUS:
    case MINUS:
    case FALSE:
    case NONE:
    case TRUE:
    case IMPORT:
    case RETURN:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:
    case MULTILINE_STRING:{
      statements = SimpleStatements();
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return new Block(statements);
}

  private void Indent() throws ParseException {String indent = getIndent();

        if(!this.indents.isEmpty()){
                String prevIndent = this.indents.peek();

                if(!(indent).startsWith(prevIndent)){
                        throw new ParseException();
                }
        }

        this.indents.push(indent);
  }

  private void Dedent() throws ParseException {this.indents.pop();
  }

  final private List<Expression> Statements() throws ParseException {Expression statement;
        List<Expression> statements = new ArrayList<>();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEWLINE:{
        jj_consume_token(NEWLINE);
        break;
        }
      case LPAREN:
      case NOT:
      case PLUS:
      case MINUS:
      case FALSE:
      case NONE:
      case TRUE:
      case IF:
      case IMPORT:
      case RETURN:
      case INT:
      case FLOAT:
      case NAME:
      case STRING:
      case MULTILINE_STRING:{
        statement = Statement();
statements.add(statement);
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEWLINE:
      case LPAREN:
      case NOT:
      case PLUS:
      case MINUS:
      case FALSE:
      case NONE:
      case TRUE:
      case IF:
      case IMPORT:
      case RETURN:
      case INT:
      case FLOAT:
      case NAME:
      case STRING:
      case MULTILINE_STRING:{
        ;
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_6;
      }
    }
return statements;
}

  final private Expression Statement() throws ParseException {Expression statement;
        List<Expression> statements;
String indent = getIndent();

                checkIndent(indent);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      statement = CompoundStatement();
      break;
      }
    case LPAREN:
    case NOT:
    case PLUS:
    case MINUS:
    case FALSE:
    case NONE:
    case TRUE:
    case IMPORT:
    case RETURN:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:
    case MULTILINE_STRING:{
      statements = SimpleStatements();
statement = getOnlyStatement(statements);
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return statement;
}

  final private Expression CompoundStatement() throws ParseException {Expression statement;
    statement = IfStatement();
return statement;
}

  final private List<Expression> SimpleStatements() throws ParseException {Expression statement;
        List<Expression> statements = new ArrayList<>();
    statement = SimpleStatement();
statements.add(statement);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_7;
      }
      jj_consume_token(SEMICOLON);
      statement = SimpleStatement();
statements.add(statement);
    }
    jj_consume_token(NEWLINE);
return statements;
}

  final private Expression SimpleStatement() throws ParseException {Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:
    case NOT:
    case PLUS:
    case MINUS:
    case FALSE:
    case NONE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:
    case MULTILINE_STRING:{
      expression = Assignment();
      break;
      }
    case RETURN:{
      expression = ReturnStatement();
      break;
      }
    case IMPORT:{
      expression = ImportStatement();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return expression;
}

  final private Apply IfStatement() throws ParseException {Expression condition;
        Block block;

        Apply if_statement;
        Apply elif_statement;

        Apply tail;
    jj_consume_token(IF);
    condition = Expression();
    jj_consume_token(COLON);
    block = Block();
if_statement = PMMLUtil.createApply(PMMLFunctions.IF, condition, getOnlyStatement(block)); tail = if_statement;
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ELIF:{
        ;
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_8;
      }
      elif_statement = ElIfStatement();
tail.addExpressions(elif_statement); tail = elif_statement;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ELSE:{
      block = ElseBlock();
tail.addExpressions(getOnlyStatement(block));
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
return if_statement;
}

  final private Apply ElIfStatement() throws ParseException {Expression condition;
        Block block;
    jj_consume_token(ELIF);
    condition = Expression();
    jj_consume_token(COLON);
    block = Block();
return PMMLUtil.createApply(PMMLFunctions.IF, condition, getOnlyStatement(block));
}

  final private Block ElseBlock() throws ParseException {Block block;
    jj_consume_token(ELSE);
    jj_consume_token(COLON);
    block = Block();
return block;
}

  final private Expression Assignment() throws ParseException {Token name;
        Expression expression;
    if (jj_2_3(2147483647)) {
      name = jj_consume_token(NAME);
      jj_consume_token(ASSIGN);
    } else {
name = null;
    }
    expression = Expression();
if(name != null){

                        if(expression instanceof FieldRef){
                                FieldRef fieldRef = (FieldRef)expression;

                                this.variableMap.put(name.image, fieldRef);

                                return null;
                        }

                        DerivedField derivedField = createDerivedField(name.image, expression);
                }

                return null;
}

  final private Expression ReturnStatement() throws ParseException {Expression expression;
    jj_consume_token(RETURN);
    expression = Expression();
return expression;
}

  final private Expression ImportStatement() throws ParseException {
    jj_consume_token(IMPORT);
    DottedAsName();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      DottedAsName();
    }
return null;
}

  final private void DottedAsName() throws ParseException {String dottedName;
        Token name = null;
    dottedName = DottedName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      name = jj_consume_token(NAME);
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      ;
    }
Map<String, String> moduleImports = getModuleImports();

                moduleImports.put(name != null ? name.image : dottedName, dottedName);
}

  final private Expression Expression() throws ParseException {Expression expression;
    expression = IfElseExpression();
return expression;
}

  final private Expression IfElseExpression() throws ParseException {Expression left;
        Expression center;
        Expression right;
    left = LogicalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      center = Expression();
      jj_consume_token(ELSE);
      right = Expression();
left = PMMLUtil.createApply(PMMLFunctions.IF, center, left, right);
      break;
      }
    default:
      jj_la1[17] = jj_gen;
      ;
    }
return left;
}

  final private Expression LogicalOrExpression() throws ParseException {Expression left;
        Expression right;
    left = LogicalAndExpression();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        break label_10;
      }
      jj_consume_token(OR);
      right = LogicalAndExpression();
left = PMMLUtil.createApply(PMMLFunctions.OR, left, right);
    }
return left;
}

  final private Expression LogicalAndExpression() throws ParseException {Expression left;
        Expression right;
    left = NegationExpression();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_11;
      }
      jj_consume_token(AND);
      right = NegationExpression();
left = PMMLUtil.createApply(PMMLFunctions.AND, left, right);
    }
return left;
}

  final private Expression NegationExpression() throws ParseException {Token operator = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      operator = jj_consume_token(NOT);
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    expression = ComparisonExpression();
if(operator != null){
                        return PMMLUtil.createApply(PMMLFunctions.NOT, expression);
                }

                return expression;
}

  final private Expression ComparisonExpression() throws ParseException {Expression left;
        Token operator;
        Object right;
    left = AdditiveExpression();
    if (jj_2_4(2147483647)) {
      jj_consume_token(IS);
      jj_consume_token(NONE);
left = PMMLUtil.createApply(PMMLFunctions.ISMISSING, left);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IS:{
        jj_consume_token(IS);
        jj_consume_token(NOT);
        jj_consume_token(NONE);
left = PMMLUtil.createApply(PMMLFunctions.ISNOTMISSING, left);
        break;
        }
      case IN:{
        jj_consume_token(IN);
        right = ListMakerExpression();
left = PMMLUtil.createApply(PMMLFunctions.ISIN, left).addExpressions((Expression[])right);
        break;
        }
      case NOT:{
        jj_consume_token(NOT);
        jj_consume_token(IN);
        right = ListMakerExpression();
left = PMMLUtil.createApply(PMMLFunctions.ISNOTIN, left).addExpressions((Expression[])right);
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQUAL:
        case NOT_EQUAL:
        case LESS_THAN:
        case LESS_OR_EQUAL:
        case GREATER_THAN:
        case GREATER_OR_EQUAL:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case EQUAL:{
            operator = jj_consume_token(EQUAL);
            break;
            }
          case NOT_EQUAL:{
            operator = jj_consume_token(NOT_EQUAL);
            break;
            }
          case LESS_THAN:{
            operator = jj_consume_token(LESS_THAN);
            break;
            }
          case LESS_OR_EQUAL:{
            operator = jj_consume_token(LESS_OR_EQUAL);
            break;
            }
          case GREATER_THAN:{
            operator = jj_consume_token(GREATER_THAN);
            break;
            }
          case GREATER_OR_EQUAL:{
            operator = jj_consume_token(GREATER_OR_EQUAL);
            break;
            }
          default:
            jj_la1[21] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          right = AdditiveExpression();
left = PMMLUtil.createApply(translateRelationalOperator(operator), left, (Expression)right);
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          ;
        }
      }
    }
return left;
}

  final private Expression AdditiveExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = MultiplicativeExpression();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        break label_12;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        operator = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        operator = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
if((operator.kind == PLUS) && (TypeUtil.isString(left, this) && TypeUtil.isString(right, this))){
                        left = PMMLUtil.createApply(PMMLFunctions.CONCAT, left, right);
                } else

                {
                        left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
                }
    }
return left;
}

  final private Expression MultiplicativeExpression() throws ParseException {Expression left;
        Token operator;
        Expression right;
    left = UnaryExpression();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case MODULO:{
        ;
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        break label_13;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MULTIPLY:{
        operator = jj_consume_token(MULTIPLY);
        break;
        }
      case DIVIDE:{
        operator = jj_consume_token(DIVIDE);
        break;
        }
      case MODULO:{
        operator = jj_consume_token(MODULO);
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
left = PMMLUtil.createApply(translateArithmeticOperator(operator), left, right);
    }
return left;
}

  final private Expression UnaryExpression() throws ParseException {Token sign = null;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:{
      sign = Sign();
      expression = UnaryExpression();
      break;
      }
    case LPAREN:
    case FALSE:
    case NONE:
    case TRUE:
    case INT:
    case FLOAT:
    case NAME:
    case STRING:
    case MULTILINE_STRING:{
      expression = PrimaryExpression();
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(sign != null && sign.kind == MINUS){
                        expression = PMMLUtil.toNegative(expression);
                }

                return expression;
}

  final private Expression PrimaryExpression() throws ParseException {String dottedName;
        Expression expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      dottedName = CanonicalizedDottedName();
      if (jj_2_5(2147483647)) {
        expression = ArrayIndexingExpression(dottedName);
        label_14:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:
          case DOT:{
            ;
            break;
            }
          default:
            jj_la1[29] = jj_gen;
            break label_14;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case DOT:{
            expression = TrailerFunctionInvocationExpression(expression);
            break;
            }
          case LBRACKET:{
            expression = StringSlicingExpression(expression);
            break;
            }
          default:
            jj_la1[30] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LPAREN:{
          expression = FunctionInvocationExpression(dottedName);
          label_15:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case LBRACKET:
            case DOT:{
              ;
              break;
              }
            default:
              jj_la1[31] = jj_gen;
              break label_15;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case DOT:{
              expression = TrailerFunctionInvocationExpression(expression);
              break;
              }
            case LBRACKET:{
              expression = StringSlicingExpression(expression);
              break;
              }
            default:
              jj_la1[32] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        default:
          jj_la1[36] = jj_gen;
          expression = NameInvocationExpression(dottedName);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:{
            expression = StringSlicingExpression(expression);
            label_16:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case LBRACKET:
              case DOT:{
                ;
                break;
                }
              default:
                jj_la1[33] = jj_gen;
                break label_16;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case DOT:{
                expression = TrailerFunctionInvocationExpression(expression);
                break;
                }
              case LBRACKET:{
                expression = StringSlicingExpression(expression);
                break;
                }
              default:
                jj_la1[34] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
            break;
            }
          default:
            jj_la1[35] = jj_gen;
            ;
          }
        }
      }
      break;
      }
    case LPAREN:{
      expression = ParenthesizedExpression();
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:
        case DOT:{
          ;
          break;
          }
        default:
          jj_la1[37] = jj_gen;
          break label_17;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOT:{
          expression = TrailerFunctionInvocationExpression(expression);
          break;
          }
        case LBRACKET:{
          expression = StringSlicingExpression(expression);
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case FALSE:
    case NONE:
    case TRUE:
    case INT:
    case FLOAT:
    case STRING:
    case MULTILINE_STRING:{
      expression = LiteralExpression();
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return expression;
}

  final private FieldRef ArrayIndexingExpression(String dottedName) throws ParseException {Token sign = null;
        Token column;

        Feature feature;
    if (jj_2_6(2147483647)) {
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        sign = Sign();
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        ;
      }
      column = jj_consume_token(INT);
      jj_consume_token(RBRACKET);
Scope scope = ensureScope();

                        int colIndex = PythonParserUtil.parseInt(sign, column);

                        feature = scope.getFeature(dottedName, colIndex);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        column = String();
        jj_consume_token(RBRACKET);
Scope scope = ensureScope();

                        String colName = PythonParserUtil.parseString(column);

                        feature = scope.getFeature(dottedName, colName);
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return feature.ref();
}

  final private Expression FunctionInvocationExpression(String dottedName) throws ParseException {List<Expression> arguments;
    arguments = Arguments();
Scope scope = ensureScope();

                int dot = dottedName.lastIndexOf('.');
                if(dot > -1){
                        String featureName = dottedName.substring(0, dot);
                        String functionName = dottedName.substring(dot + 1);

                        Feature feature = scope.resolveFeature(featureName);
                        if(feature != null){
                                return translateTrailerFunction(feature.ref(), functionName, arguments);
                        }
                }

                return encodeFunction(dottedName, arguments);
}

  final private Apply TrailerFunctionInvocationExpression(Expression expression) throws ParseException {Token name;
        List<Expression> arguments;
    jj_consume_token(DOT);
    name = jj_consume_token(NAME);
    arguments = Arguments();
return translateTrailerFunction(expression, name.image, arguments);
}

  final private List<Expression> Arguments() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    if (jj_2_7(2147483647)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        expression = Expression();
expressions.add(expression);
        label_18:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[42] = jj_gen;
            break label_18;
          }
          jj_consume_token(COMMA);
          expression = Expression();
expressions.add(expression);
        }
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return expressions;
}

  final private Expression StringSlicingExpression(Expression expression) throws ParseException {Token startSign = null;
        Token start = null;
        Token stopSign = null;
        Token stop = null;
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case INT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        startSign = Sign();
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      start = jj_consume_token(INT);
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case INT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        stopSign = Sign();
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        ;
      }
      stop = jj_consume_token(INT);
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
Integer startPos = null;
                if(start != null){
                        startPos = PythonParserUtil.parseInt(startSign, start);
                }

                Integer stopPos = null;
                if(stop != null){
                        stopPos = PythonParserUtil.parseInt(stopSign, stop);
                }

                return translateStringSlice(expression, startPos, stopPos);
}

  final private Expression NameInvocationExpression(String dottedName) throws ParseException {
int dot = dottedName.indexOf('.');
                if(dot > -1){
                        return encodeConstant(dottedName);
                }

                FieldRef fieldRef = this.variableMap.get(dottedName);
                if(fieldRef != null){
                        return fieldRef;
                }

                Scope scope = ensureScope();

                Feature feature = scope.getFeature(dottedName);

                return feature.ref();
}

  final private Expression ParenthesizedExpression() throws ParseException {Expression expression;
    jj_consume_token(LPAREN);
    expression = Expression();
    jj_consume_token(RPAREN);
return expression;
}

  final private Constant LiteralExpression() throws ParseException {Token value;
        DataType dataType;
        Boolean missing = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NONE:{
      value = jj_consume_token(NONE);
dataType = null; missing = Boolean.TRUE;
      break;
      }
    case FALSE:{
      value = jj_consume_token(FALSE);
dataType = DataType.BOOLEAN;
      break;
      }
    case TRUE:{
      value = jj_consume_token(TRUE);
dataType = DataType.BOOLEAN;
      break;
      }
    case INT:{
      value = jj_consume_token(INT);
dataType = DataType.INTEGER;
      break;
      }
    case FLOAT:{
      value = jj_consume_token(FLOAT);
dataType = DataType.DOUBLE;
      break;
      }
    case STRING:
    case MULTILINE_STRING:{
      value = String();
dataType = DataType.STRING;
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
Constant constant = new Constant()
                        .setValue(PythonParserUtil.parseValue(value))
                        .setDataType(dataType)
                        .setMissing(missing);

                return constant;
}

  final private Expression[] ListMakerExpression() throws ParseException {Expression expression;
        List<Expression> expressions = new ArrayList<Expression>();
    jj_consume_token(LBRACKET);
    expression = Expression();
expressions.add(expression);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      expression = Expression();
expressions.add(expression);
    }
    jj_consume_token(RBRACKET);
return expressions.toArray(new Expression[expressions.size()]);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_3R_ArrayIndexingExpression_1107_17_22()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayIndexingExpression_1108_29_25()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_null_1107_39_21()
 {
    if (jj_3R_Sign_577_9_24()) return true;
    return false;
  }

  private boolean jj_3R_String_561_9_26()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) return true;
    }
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_Sign_577_9_24()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) return true;
    }
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_ArrayIndexingExpression_1106_9_20()) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_1106_9_20()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayIndexingExpression_1107_17_22()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayIndexingExpression_1116_17_23()) return true;
    }
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_1108_29_25()
 {
    if (jj_3R_Sign_577_9_24()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_null_1107_39_21()) jj_scanpos = xsp;
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_ArrayIndexingExpression_1116_17_23()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_String_561_9_26()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public PythonParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[50];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x30000,0x8,0x8,0x1000000,0x10,0x8,0x70030118,0x70030118,0x70030118,0x70030110,0x8000000,0x70030110,0x0,0x0,0x1000000,0x80000000,0x0,0x40,0x80,0x100,0x7e00,0x7e00,0x100,0x30000,0x30000,0x1c0000,0x1c0000,0x70030010,0x2400000,0x2400000,0x2400000,0x2400000,0x2400000,0x2400000,0x400000,0x10,0x2400000,0x2400000,0x70000010,0x30000,0x400000,0x1000000,0x10,0x30000,0x30000,0x30000,0x30000,0x70000000,0x1000000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x40800,0x0,0x0,0x0,0x0,0x0,0x0,0x40f90,0x40f98,0x40f98,0x40f98,0x0,0x40f90,0x2,0x4,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x60,0x0,0x0,0x0,0x0,0x40f00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40f00,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x100,0x40b00,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public ExpressionTranslator(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new PythonParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 50; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new PythonParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 50; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public ExpressionTranslator(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 50; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 50; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[51];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 50; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 51; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : PythonParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 7; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
